---
generated_at: 2026-01-22 14:05:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：101-ScheduleMigrateExternalDiffsWorker.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **実行頻度の具体的な時刻設定**：Cronスケジュールの設定ファイルが見つからず

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/schedule_migrate_external_diffs_worker.rb`
- E-02: `app/services/merge_requests/migrate_external_diffs_service.rb`
- E-03: `app/models/merge_request_diff.rb`（194-234行目）
- E-04: `app/workers/migrate_external_diffs_worker.rb`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 排他ロックを使用して同時実行を防止する | E-01（19-21行目: in_lock, ttl: 2.hours） | ○ |
| C-02 | TTLは2時間 | E-01（19行目: ttl: 2.hours） | ○ |
| C-03 | MigrateExternalDiffsService.enqueue!を呼び出す | E-01（20行目） | ○ |
| C-04 | 最大1000件のIDを取得 | E-02（5行目: MAX_JOBS = 1000） | ○ |
| C-05 | MigrateExternalDiffsWorkerをバルクキューイング | E-02（14行目: bulk_perform_async） | ○ |
| C-06 | feature_categoryはcode_review_workflow | E-01（16行目） | ○ |
| C-07 | data_consistencyはalways | E-01（6行目） | ○ |
| C-08 | CronjobQueueをincludeしている | E-01（11行目） | ○ |
| C-09 | 外部差分が無効の場合は空配列を返す | E-03（195行目） | ○ |
| C-10 | 戦略は'always'と'outdated'の2種類 | E-03（197-204行目） | ○ |
| C-11 | outdated戦略ではEXTERNAL_DIFF_CUTOFF（7日）を使用 | E-03（22行目、213行目） | ○ |
| C-12 | FailedToObtainLockErrorをrescueする | E-01（22行目） | ○ |
| C-13 | 非冪等ワーカー | E-01（3行目: rubocop:disable Scalability/IdempotentWorker） | ○ |
| C-14 | MigrateExternalDiffsWorkerはretry: 3 | E-04（8行目） | ○ |
| C-15 | Cronの具体的な実行時刻 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Cronスケジュールの具体的な設定値
  - 候補：`config/initializers/1_settings.rb` / `config/gitlab.yml` / Sidekiq-cronの設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な処理ロジックはすべてソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Cronスケジュールの実行頻度を確認（運用環境の設定を参照）
- [ ] 外部差分の設定（external_diffs.enabled、external_diffs.when）が期待通りか確認
- [ ] 1000件/実行の処理件数が運用要件を満たすか確認
