---
generated_at: 2026-01-22 14:06:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：102-Releases_ManageEvidenceWorker.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/releases/manage_evidence_worker.rb`
- E-02: `app/workers/releases/create_evidence_worker.rb`
- E-03: `app/models/release.rb`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CronjobQueueをincludeしている | E-01（6行目） | ○ |
| C-02 | feature_categoryはrelease_evidence | E-01（9行目） | ○ |
| C-03 | data_consistencyはsticky | E-01（8行目） | ○ |
| C-04 | without_evidenceとreleased_within_2hrsスコープで対象取得 | E-01（16行目） | ○ |
| C-05 | 各リリースをeachで処理 | E-01（18行目） | ○ |
| C-06 | TIMEOUT_EXCEPTIONSで複数の例外をハンドリング | E-01（11-13行目） | ○ |
| C-07 | StandardErrorもrescue対象 | E-01（20行目） | ○ |
| C-08 | ErrorTrackingで例外を記録 | E-01（21-25行目） | ○ |
| C-09 | プロジェクトがnilの場合はreturn | E-01（33行目） | ○ |
| C-10 | EvidencePipelineFinderでパイプライン検索 | E-01（35行目） | ○ |
| C-11 | CreateEvidenceWorker.perform_asyncを呼び出す | E-01（38行目） | ○ |
| C-12 | released_within_2hrsは前後1時間 | E-03（60行目） | ○ |
| C-13 | without_evidenceはLEFT JOINで実装 | E-03（59行目） | ○ |
| C-14 | CreateEvidenceWorkerはretry: 3 | E-02（11行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な処理ロジックはすべてソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] エビデンス生成のタイミング（前後1時間）が業務要件を満たすか確認
- [ ] エラー発生時の継続処理が問題ないか確認
- [ ] パイプラインが存在しない場合のエビデンス生成が意図通りか確認
