---
generated_at: 2026-01-22 14:07:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：103-Releases_PublishEventWorker.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/releases/publish_event_worker.rb`
- E-02: `app/models/release.rb`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CronjobQueueをincludeしている | E-01（6行目） | ○ |
| C-02 | idempotent!で冪等性を宣言 | E-01（8行目） | ○ |
| C-03 | feature_categoryはrelease_orchestration | E-01（10行目） | ○ |
| C-04 | data_consistencyはalways | E-01（9行目） | ○ |
| C-05 | waiting_for_publish_eventで対象取得 | E-01（15行目） | ○ |
| C-06 | each_batch(of: 100)で100件ずつ処理 | E-01（15行目） | ○ |
| C-07 | with_contextでプロジェクトコンテキスト設定 | E-01（17行目） | ○ |
| C-08 | EventStore.publishでReleasePublishedEvent発行 | E-01（18-19行目） | ○ |
| C-09 | touch_allでrelease_published_atを更新 | E-01（26行目） | ○ |
| C-10 | log_extra_metadata_on_doneで公開件数を記録 | E-01（29行目） | ○ |
| C-11 | MAX_NUMBER_TO_PUBLISHは5000 | E-02（74行目） | ○ |
| C-12 | waiting_for_publish_eventはunpublishedとreleased_within_2hrsを結合 | E-02（107-108行目） | ○ |
| C-13 | with_feature_enabled(:releases)でフィルタ | E-02（108行目） | ○ |
| C-14 | unpublishedはrelease_published_at IS NULL | E-02（61行目） | ○ |
| C-15 | released_within_2hrsは前後1時間 | E-02（60行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な処理ロジックはすべてソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] MAX_NUMBER_TO_PUBLISH（5000件）が運用要件を満たすか確認
- [ ] イベント発行の遅延が許容範囲内か確認
- [ ] touch_allの一括更新によるロック競合がないか確認
