---
generated_at: 2026-01-22 14:09:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：105-ServiceDesk_CustomEmailVerificationCleanupWorker.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/service_desk/custom_email_verification_cleanup_worker.rb`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CronjobQueueをincludeしている | E-01（12行目） | ○ |
| C-02 | idempotent!で冪等性を宣言 | E-01（14行目） | ○ |
| C-03 | feature_categoryはservice_desk | E-01（17行目） | ○ |
| C-04 | data_consistencyはsticky | E-01（16行目） | ○ |
| C-05 | started.overdue.limit(2400)で対象取得 | E-01（21行目） | ○ |
| C-06 | find_eachで順次処理 | E-01（23行目） | ○ |
| C-07 | with_contextでプロジェクトコンテキスト設定 | E-01（24行目） | ○ |
| C-08 | UpdateServiceを呼び出す | E-01（25-30行目） | ○ |
| C-09 | mail: nilパラメータで呼び出し | E-01（28行目） | ○ |
| C-10 | current_user: nilで呼び出し | E-01（27行目） | ○ |
| C-11 | verification.projectでプロジェクト取得 | E-01（24行目、26行目） | ○ |
| C-12 | 上限2400件は50ms/件×2400=2分の想定 | E-01（20行目のコメント） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な処理ロジックはすべてソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] overdueスコープの定義（CustomEmailVerificationモデル）を確認
- [ ] UpdateServiceの検証失敗処理ロジックを確認
- [ ] 2400件の上限が運用要件を満たすか確認
