---
generated_at: 2026-01-22 14:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：106-ConcurrencyLimit_ResumeWorker.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/concurrency_limit/resume_worker.rb`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CronjobQueueをincludeしている | E-01（6行目） | ○ |
| C-02 | RESCHEDULE_DELAYは1秒 | E-01（9行目） | ○ |
| C-03 | feature_categoryはscalability | E-01（11行目） | ○ |
| C-04 | data_consistencyはsticky | E-01（12行目） | ○ |
| C-05 | idempotent!で冪等性を宣言 | E-01（13行目） | ○ |
| C-06 | urgencyはlow | E-01（14行目） | ○ |
| C-07 | loggable_arguments 0 | E-01（15行目） | ○ |
| C-08 | concurrency_limit -> { 0 }で自身を除外 | E-01（18行目） | ○ |
| C-09 | worker_nameの有無で処理を分岐 | E-01（20-25行目） | ○ |
| C-10 | schedule_workersで全ワーカーをスキャン | E-01（30-39行目） | ○ |
| C-11 | キューサイズ > 0 かつ制限 >= 0 で再開 | E-01（35-36行目） | ○ |
| C-12 | process_workerで指定ワーカーを処理 | E-01（51-78行目） | ○ |
| C-13 | safe_constantizeでワーカークラスを取得 | E-01（52行目） | ○ |
| C-14 | worker_stats_logでログ出力 | E-01（64-66行目） | ○ |
| C-15 | resume_processing!でジョブ再開 | E-01（68行目） | ○ |
| C-16 | cleanup_stale_trackersでクリーンアップ | E-01（69行目） | ○ |
| C-17 | キューにジョブがあれば1秒後に再スケジュール | E-01（71-75行目） | ○ |
| C-18 | log_extra_metadata_on_doneで再開ジョブ数を記録 | E-01（77行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な処理ロジックはすべてソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] ConcurrencyLimitServiceの実装を確認
- [ ] SidekiqSharding::Routerの動作を確認
- [ ] サーキットブレーカー（limit < 0）の発動条件を確認
