---
generated_at: 2026-01-22 14:12:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：108-AdminEmailWorker.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/admin_email_worker.rb`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CronjobQueueをincludeしている | E-01（10行目） | ○ |
| C-02 | feature_categoryはsource_code_management | E-01（14行目） | ○ |
| C-03 | data_consistencyはsticky | E-01（6行目） | ○ |
| C-04 | repository_checks_enabledをチェック | E-01（17行目） | ○ |
| C-05 | send_repository_check_mailメソッドを呼び出す | E-01（17行目） | ○ |
| C-06 | Project.last_repository_check_failedで件数取得 | E-01（23行目） | ○ |
| C-07 | 件数が0の場合はreturn | E-01（24行目） | ○ |
| C-08 | RepositoryCheckMailer.notifyでメール送信 | E-01（26行目） | ○ |
| C-09 | deliver_nowで同期送信 | E-01（26行目） | ○ |
| C-10 | 非冪等ワーカー（rubocop disable） | E-01（3行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な処理ロジックはすべてソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] last_repository_check_failedスコープの定義を確認
- [ ] RepositoryCheckMailerのテンプレートを確認
- [ ] 管理者メールの送信先設定を確認
