---
generated_at: 2026-01-22 14:13:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：109-Cells_LostTransactionRecoveryWorker.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/cells/lost_transaction_recovery_worker.rb`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CronjobQueueをincludeしている | E-01（6行目） | ○ |
| C-02 | sidekiq_options retry: 3 | E-01（8行目） | ○ |
| C-03 | feature_categoryはcell | E-01（11行目） | ○ |
| C-04 | data_consistencyはsticky | E-01（10行目） | ○ |
| C-05 | urgencyはlow | E-01（12行目） | ○ |
| C-06 | queue_namespaceはcronjob | E-01（13行目） | ○ |
| C-07 | idempotent!で冪等性を宣言 | E-01（14行目） | ○ |
| C-08 | defer_on_database_health_signalで1分遅延 | E-01（16行目） | ○ |
| C-09 | Current.cells_claims_leases?で有効チェック | E-01（19行目） | ○ |
| C-10 | ReconciliationService.new.executeを呼び出す | E-01（21行目） | ○ |
| C-11 | log_hash_metadata_on_doneで結果を記録 | E-01（23-30行目） | ○ |
| C-12 | 5つの指標を記録（processed, committed, rolled_back, pending, orphaned） | E-01（26-30行目） | ○ |
| C-13 | StandardErrorをrescue | E-01（31行目） | ○ |
| C-14 | ErrorTracking.track_exceptionで記録 | E-01（32行目） | ○ |
| C-15 | feature_category: :cellを指定 | E-01（32行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な処理ロジックはすべてソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] ReconciliationServiceの実装を確認
- [ ] Cellsリース機構の動作を確認
- [ ] Current.cells_claims_leases?の設定条件を確認
