---
generated_at: 2026-01-22 14:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：11-Ci_ScheduleBulkDeleteJobArtifactCronWorker

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **実行スケジュールの具体的な間隔**：Cronスケジュール設定ファイル未確認
  2. **監視・アラート閾値**：具体的な閾値設定の根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/ci/schedule_bulk_delete_job_artifact_cron_worker.rb`
- E-02: `app/workers/ci/bulk_delete_expired_job_artifacts_worker.rb`
- E-03: `lib/gitlab/ci/artifacts/bucket_manager.rb`
- E-04: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Feature flag bulk_delete_job_artifacts で制御される | E-01 L13 | ○ |
| C-02 | idempotent ワーカーである | E-01 L8 | ○ |
| C-03 | feature_category は job_artifacts | E-01 L9 | ○ |
| C-04 | data_consistency は sticky | E-01 L10 | ○ |
| C-05 | max_buckets は max_running_jobs_limit から取得 | E-01 L15 | ○ |
| C-06 | 停滞バケットを回復する | E-01 L16, E-03 L38-51 | ○ |
| C-07 | 欠落バケットを補充する | E-01 L18-20, E-03 L56-69 | ○ |
| C-08 | BulkDeleteExpiredJobArtifactsWorker を呼び出す | E-01 L22 | ○ |
| C-09 | メタデータをログ出力する | E-01 L24-30 | ○ |
| C-10 | max_running_jobs_limit は 5 または 10 | E-02 L17-23 | ○ |
| C-11 | STALE_BUCKET_THRESHOLD は 10分 | E-03 L10 | ○ |
| C-12 | Redisキーはハッシュタグで同一スロットに配置 | E-03 L8-9 | ○ |
| C-13 | バケットはSPOPでアトミックに取得 | E-03 L16 | ○ |
| C-14 | bulk_delete_job_artifacts_high_concurrency で並列度変更可能 | E-02 L18 | ○ |
| C-15 | バケット分割はMOD演算で実現 | E-02 L76 | ○ |
| C-16 | CronjobQueue を include | E-01 L6 | ○ |
| C-17 | 実行間隔は数分間隔 | **根拠なし** | △ |
| C-18 | 監視閾値60秒、連続3回失敗 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Cronスケジュール設定ファイル（gitlab.yml または sidekiq-cron設定）が未確認のため、実行間隔の正確な値を特定できていない
  - 候補：config/gitlab.yml / config/initializers/1_settings.rb / sidekiq-cron設定
- 監視・アラート閾値は運用ドキュメントまたはPrometheus設定から確認が必要
  - 候補：.gitlab/dashboards / runbooks

## 5) リスクフラグ（レビュー観点）
- 0: Feature flag制御、idempotent設計、Redisアトミック操作 - 低リスク
- 1: 実行スケジュールの具体値 - 中リスク（確認推奨）
- 0: バケット管理ロジック - コードで明確に確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 実行スケジュール設定が運用要件と合致しているか確認
- [ ] Feature flag の有効化手順が運用ドキュメントに記載されているか確認
- [ ] max_buckets の設定値が現在の並列度要件に適切か確認
- [ ] 監視・アラート設定が実際のPrometheus/Grafana設定と一致しているか確認
