---
generated_at: 2026-01-22 14:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：12-Ci_ScheduleDeleteObjectsCronWorker

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **実行スケジュールの具体的な間隔**：Cronスケジュール設定ファイル未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/ci/schedule_delete_objects_cron_worker.rb`
- E-02: `app/workers/ci/delete_objects_worker.rb`
- E-03: `app/services/ci/delete_objects_service.rb`
- E-04: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | data_consistency は :always | E-01 L7 | ○ |
| C-02 | CronjobQueue を include | E-01 L11 | ○ |
| C-03 | feature_category は continuous_integration | E-01 L14 | ○ |
| C-04 | idempotent ワーカーである | E-01 L15 | ○ |
| C-05 | DeleteObjectsWorker.perform_with_capacity を呼び出す | E-01 L17-18 | ○ |
| C-06 | 子ワーカーの sidekiq_options retry は 3 | E-02 L8 | ○ |
| C-07 | 子ワーカーは LimitedCapacity::Worker を include | E-02 L11 | ○ |
| C-08 | max_running_jobs は 50 | E-02 L25-27 | ○ |
| C-09 | BATCH_SIZE は 100 | E-03 L7 | ○ |
| C-10 | RETRY_IN は 10分 | E-03 L8 | ○ |
| C-11 | ACCEPTABLE_DELAY は 12時間 | E-03 L9 | ○ |
| C-12 | TransactionInProgressError の定義 | E-03 L5-6 | ○ |
| C-13 | トランザクション内ストレージ削除を禁止 | E-03 L57-58 | ○ |
| C-14 | 削除成功でメトリクス記録 | E-03 L77-79 | ○ |
| C-15 | 削除失敗でエラーメトリクス記録 | E-03 L81 | ○ |
| C-16 | 具体的な実行間隔 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Cronスケジュール設定ファイルが未確認のため、実行間隔の正確な値を特定できていない
  - 候補：config/initializers/1_settings.rb / sidekiq-cron設定 / gitlab.yml

## 5) リスクフラグ（レビュー観点）
- 0: 親ワーカーのシンプルな設計 - 低リスク
- 0: 子ワーカーの詳細ロジック - コードで明確に確認可能
- 1: 実行スケジュールの具体値 - 中リスク（確認推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] 実行スケジュール設定が運用要件と合致しているか確認
- [ ] max_running_jobs = 50 が現在のインフラ構成に適切か確認
- [ ] ACCEPTABLE_DELAY = 12時間が SLO 要件を満たしているか確認
- [ ] ci_deleted_objects テーブルの増加傾向をモニタリングしているか確認
