---
generated_at: 2026-01-22 14:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：13-Ci_UpdateLockedUnknownArtifactsWorker

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **実行スケジュールの具体的な間隔**：Cronスケジュール設定ファイル未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/ci/update_locked_unknown_artifacts_worker.rb`
- E-02: `app/services/ci/job_artifacts/update_unknown_locked_status_service.rb`
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | data_consistency は :sticky | E-01 L7 | ○ |
| C-02 | urgency は :throttled | E-01 L8 | ○ |
| C-03 | CronjobQueue を include | E-01 L12 | ○ |
| C-04 | feature_category は job_artifacts | E-01 L15 | ○ |
| C-05 | UpdateUnknownLockedStatusService を呼び出す | E-01 L18 | ○ |
| C-06 | removed_count をログ出力 | E-01 L20 | ○ |
| C-07 | locked_count をログ出力 | E-01 L21 | ○ |
| C-08 | BATCH_SIZE は 100 | E-02 L9 | ○ |
| C-09 | LOOP_TIMEOUT は 5分 | E-02 L10 | ○ |
| C-10 | LOOP_LIMIT は 100 | E-02 L11 | ○ |
| C-11 | EXCLUSIVE_LOCK_KEY の定義 | E-02 L12 | ○ |
| C-12 | LOCK_TIMEOUT は 6分 | E-02 L13 | ○ |
| C-13 | 排他ロックのリトライは1回 | E-02 L22 | ○ |
| C-14 | with_pipeline_locked_artifacts でパイプラインロック確認 | E-02 L35-38 | ○ |
| C-15 | artifacts_locked に更新 | E-02 L40 | ○ |
| C-16 | DestroyBatchService で削除 | E-02 L62 | ○ |
| C-17 | idempotent ではない | E-01 L4 コメント | ○ |
| C-18 | 具体的な実行間隔 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Cronスケジュール設定ファイルが未確認のため、実行間隔の正確な値を特定できていない
  - 候補：config/initializers/1_settings.rb / sidekiq-cron設定

## 5) リスクフラグ（レビュー観点）
- 0: サービスクラスの詳細ロジック - コードで明確に確認可能
- 0: 排他ロック機構 - 設計通りに実装されている
- 1: 実行スケジュールの具体値 - 中リスク（確認推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] 実行スケジュール設定が運用要件と合致しているか確認
- [ ] LOOP_TIMEOUT と LOCK_TIMEOUT の関係が適切か確認（LOCK > LOOP）
- [ ] 大量の unknown アーティファクトが存在する場合の処理時間を確認
- [ ] removed_count の監視アラートが設定されているか確認
