---
generated_at: 2026-01-22 14:15:00
metrics:
  claims_total: 17
  claims_with_evidence: 16
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：14-ContainerExpirationPolicyWorker

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：16 / 17、根拠なし：1
- 優先レビュー（高）
  1. **実行スケジュールの具体的な間隔**：Cronスケジュール設定ファイル未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/container_expiration_policy_worker.rb`
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | data_consistency は :always | E-01 L6 | ○ |
| C-02 | CronjobQueue を include | E-01 L10 | ○ |
| C-03 | ExclusiveLeaseGuard を include | E-01 L13 | ○ |
| C-04 | feature_category は container_registry | E-01 L15 | ○ |
| C-05 | InvalidPolicyError の定義 | E-01 L17 | ○ |
| C-06 | BATCH_SIZE は 1000 | E-01 L19 | ○ |
| C-07 | process_stale_ongoing_cleanups を実行 | E-01 L22 | ○ |
| C-08 | disable_policies_without_container_repositories を実行 | E-01 L23 | ○ |
| C-09 | CleanupContainerRepositoryWorker.perform_with_capacity を呼び出す | E-01 L25 | ○ |
| C-10 | log_counts でメタデータ出力 | E-01 L27 | ○ |
| C-11 | コンテナなしポリシーを無効化 | E-01 L32-37 | ○ |
| C-12 | レプリカを使用してカウント取得 | E-01 L53-57 | ○ |
| C-13 | 停滞判定閾値は timeout + 30分 | E-01 L60-61 | ○ |
| C-14 | lease_timeout は 5時間 | E-01 L65-67 | ○ |
| C-15 | delete_tags_service_timeout を ApplicationSettings から取得 | E-01 L69-71 | ○ |
| C-16 | idempotent ではない | E-01 L3 コメント | ○ |
| C-17 | 具体的な実行間隔 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Cronスケジュール設定ファイルが未確認のため、実行間隔の正確な値を特定できていない
  - 候補：config/initializers/1_settings.rb / sidekiq-cron設定

## 5) リスクフラグ（レビュー観点）
- 0: ワーカーの処理ロジック - コードで明確に確認可能
- 0: 排他制御機構 - ExclusiveLeaseGuard で適切に実装
- 1: 実行スケジュールの具体値 - 中リスク（確認推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] 実行スケジュール設定が運用要件と合致しているか確認
- [ ] lease_timeout = 5時間が実際の処理時間に対して適切か確認
- [ ] delete_tags_service_timeout の現在の設定値を確認
- [ ] コンテナレジストリのストレージ使用量モニタリングが設定されているか確認
