---
generated_at: 2026-01-22 14:20:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：15-ContainerRegistry_CleanupWorker

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **実行スケジュールの具体的な間隔**：Cronスケジュール設定ファイル未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/container_registry/cleanup_worker.rb`
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CronjobQueue を include | E-01 L7 | ○ |
| C-02 | data_consistency は :always | E-01 L9 | ○ |
| C-03 | idempotent ワーカーである | E-01 L10 | ○ |
| C-04 | feature_category は container_registry | E-01 L12 | ○ |
| C-05 | STALE_DELETE_THRESHOLD は 30分 | E-01 L14 | ○ |
| C-06 | STALE_REPAIR_DETAIL_THRESHOLD は 2時間 | E-01 L15 | ○ |
| C-07 | BATCH_SIZE は 200 | E-01 L16 | ○ |
| C-08 | reset_stale_deletes を実行 | E-01 L19 | ○ |
| C-09 | delete_stale_ongoing_repair_details を実行 | E-01 L20 | ○ |
| C-10 | DeleteContainerRepositoryWorker を呼び出す | E-01 L22, L47 | ○ |
| C-11 | RecordDataRepairDetailWorker を呼び出す | E-01 L23, L51 | ○ |
| C-12 | GitLab.com（Jihuを除く）でのみ修復ワーカー起動 | E-01 L55 | ○ |
| C-13 | Feature flag registry_data_repair_worker の確認 | E-01 L56 | ○ |
| C-14 | GitLab API サポート確認 | E-01 L57 | ○ |
| C-15 | pending_data_repair_analysis の存在確認 | E-01 L59 | ○ |
| C-16 | 具体的な実行間隔 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Cronスケジュール設定ファイルが未確認のため、実行間隔の正確な値を特定できていない
  - 候補：config/initializers/1_settings.rb / sidekiq-cron設定

## 5) リスクフラグ（レビュー観点）
- 0: ワーカーの処理ロジック - コードで明確に確認可能
- 0: 各種閾値設定 - 定数として明確に定義
- 1: 実行スケジュールの具体値 - 中リスク（確認推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] 実行スケジュール設定が運用要件と合致しているか確認
- [ ] STALE_DELETE_THRESHOLD = 30分が実際の削除処理時間に対して適切か確認
- [ ] GitLab.com 以外の環境でデータ修復が必要な場合の対応方針を確認
- [ ] container_registry_data_repair_details テーブルの増加傾向をモニタリングしているか確認
