---
generated_at: 2026-01-22 14:30:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：17-Database_PartitionManagementWorker

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **実行スケジュールの具体的な間隔**：Cronスケジュール設定ファイル未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/database/partition_management_worker.rb`
- E-02: `lib/gitlab/database/partitioning.rb`
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CronjobQueue を include | E-01 L7 | ○ |
| C-02 | data_consistency は :always | E-01 L9 | ○ |
| C-03 | feature_category は database | E-01 L11 | ○ |
| C-04 | idempotent ワーカーである | E-01 L12 | ○ |
| C-05 | Gitlab::Database::Partitioning.sync_partitions を呼び出す | E-01 L15 | ○ |
| C-06 | ensure句で report_metrics を呼び出す | E-01 L17 | ○ |
| C-07 | disallow_database_ddl_feature_flags でスキップ | E-02 L43 | ○ |
| C-08 | partition_manager_sync_partitions でスキップ | E-02 L45 | ○ |
| C-09 | 同期開始ログ出力 | E-02 L47 | ○ |
| C-10 | 同期完了ログ出力 | E-02 L67 | ○ |
| C-11 | PartitionManager.sync_partitions を実行 | E-02 L50 | ○ |
| C-12 | 本番環境では owner_db_only = true | E-02 L42 | ○ |
| C-13 | SharedModel は全DBに同期 | E-02 L56 | ○ |
| C-14 | PartitionMonitoring.report_metrics_for_model | E-02 L73 | ○ |
| C-15 | analyze オプションのサポート | E-02 L50 | ○ |
| C-16 | 具体的な実行間隔 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Cronスケジュール設定ファイルが未確認のため、実行間隔の正確な値を特定できていない
  - 候補：config/initializers/1_settings.rb / sidekiq-cron設定

## 5) リスクフラグ（レビュー観点）
- 0: パーティション同期ロジック - コードで明確に確認可能
- 0: Feature flag制御 - 明確に定義
- 1: 実行スケジュールの具体値 - 中リスク（確認推奨）
- 1: DDL操作 - 本番環境への影響を確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] 実行スケジュール設定が運用要件と合致しているか確認
- [ ] 登録されているパーティションモデルのリストを確認
- [ ] Feature flag の現在の設定状態を確認
- [ ] Prometheusメトリクスが正しく収集されているか確認
- [ ] パーティション作成のDDL実行が本番環境に影響を与えていないか確認
