---
generated_at: 2026-01-22 14:35:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：18-Database_DropDetachedPartitionsWorker

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **実行スケジュールの具体的な間隔**：Cronスケジュール設定ファイル未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/database/drop_detached_partitions_worker.rb`
- E-02: `lib/gitlab/database/partitioning.rb`
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CronjobQueue を include | E-01 L6 | ○ |
| C-02 | feature_category は database | E-01 L8 | ○ |
| C-03 | data_consistency は :always | E-01 L9 | ○ |
| C-04 | idempotent ワーカーである | E-01 L10 | ○ |
| C-05 | Gitlab::Database::Partitioning.drop_detached_partitions を呼び出す | E-01 L13 | ○ |
| C-06 | ensure句で report_metrics を呼び出す | E-01 L15 | ○ |
| C-07 | disallow_database_ddl_feature_flags でスキップ | E-02 L79 | ○ |
| C-08 | partition_manager_sync_partitions でスキップ | E-02 L81 | ○ |
| C-09 | 削除開始ログ出力 | E-02 L83 | ○ |
| C-10 | 削除完了ログ出力 | E-02 L89 | ○ |
| C-11 | 各DB接続で DetachedPartitionDropper 実行 | E-02 L85-87 | ○ |
| C-12 | EachDatabase.each_connection で各DB処理 | E-02 L85 | ○ |
| C-13 | PartitionManagementWorker と同じ Feature flag | E-02 L79, L81 | ○ |
| C-14 | 具体的な実行間隔 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Cronスケジュール設定ファイルが未確認のため、実行間隔の正確な値を特定できていない
  - 候補：config/initializers/1_settings.rb / sidekiq-cron設定
- DetachedPartitionDropper クラスの詳細実装は別ファイルにあるが未参照

## 5) リスクフラグ（レビュー観点）
- 0: 削除ロジック - コードで明確に確認可能
- 0: Feature flag制御 - PartitionManagementWorker と同様
- 1: 実行スケジュールの具体値 - 中リスク（確認推奨）
- 1: DROP TABLE操作 - 本番環境への影響を確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] 実行スケジュール設定が運用要件と合致しているか確認
- [ ] detached_partitions テーブルの現在のレコード数を確認
- [ ] drop_after までの待機期間が適切か確認
- [ ] 大きなパーティション削除時のI/O負荷をモニタリングしているか確認
