---
generated_at: 2026-01-22 14:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：19-Database_MonitorLockedTablesWorker

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **実行スケジュールの具体的な間隔**：Cronスケジュール設定ファイル未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/database/monitor_locked_tables_worker.rb`
- E-02: `lib/gitlab/database/tables_locker.rb`
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CronjobQueue を include | E-01 L6 | ○ |
| C-02 | sidekiq_options retry: false | E-01 L8 | ○ |
| C-03 | feature_category は :cell | E-01 L9 | ○ |
| C-04 | data_consistency は :sticky | E-01 L10 | ○ |
| C-05 | idempotent ワーカーである | E-01 L11 | ○ |
| C-06 | version 1 | E-01 L13 | ○ |
| C-07 | INITIAL_DATABASE_RESULT の定義 | E-01 L15-20 | ○ |
| C-08 | マルチDBモードでない場合リターン | E-01 L23 | ○ |
| C-09 | Feature flag monitor_database_locked_tables の確認 | E-01 L24 | ○ |
| C-10 | TablesLocker でドライラン | E-01 L26-27 | ○ |
| C-11 | include_partitions: false | E-01 L27 | ○ |
| C-12 | lock_tables_in_monitoring Feature flag | E-01 L39 | ○ |
| C-13 | disallow_database_ddl_feature_flags 確認 | E-01 L40 | ○ |
| C-14 | LockTablesWorker を起動 | E-01 L42 | ○ |
| C-15 | メタデータログ出力 | E-01 L45 | ○ |
| C-16 | needs_lock, needs_unlock の集計 | E-01 L50-58 | ○ |
| C-17 | GITLAB_SCHEMAS_TO_IGNORE の定義 | E-02 L6 | ○ |
| C-18 | 具体的な実行間隔 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Cronスケジュール設定ファイルが未確認のため、実行間隔の正確な値を特定できていない
  - 候補：config/initializers/1_settings.rb / sidekiq-cron設定

## 5) リスクフラグ（レビュー観点）
- 0: 監視ロジック - コードで明確に確認可能
- 0: Feature flag制御 - 複数のフラグで慎重に制御
- 1: 実行スケジュールの具体値 - 中リスク（確認推奨）
- 1: 自動ロック機能 - 本番環境での有効化状態を確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] 実行スケジュール設定が運用要件と合致しているか確認
- [ ] マルチデータベースモードが正しく設定されているか確認
- [ ] Feature flag の現在の設定状態を確認（monitor_database_locked_tables, lock_tables_in_monitoring）
- [ ] tables_need_lock_count の監視アラートが設定されているか確認
- [ ] GITLAB_SCHEMAS_TO_IGNORE が現在のスキーマ構成と一致しているか確認
