---
generated_at: 2026-01-22 14:05:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：2-StuckCiJobsWorker.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **削除ジョブ数の異常増加閾値**：具体的な閾値の根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/stuck_ci_jobs_worker.rb`
- E-02: `app/services/ci/stuck_builds/drop_pending_service.rb`
- E-03: `app/services/ci/stuck_builds/drop_helpers.rb`
- E-04: `config/initializers/1_settings.rb`
- E-05: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MINUTES_BETWEEN_RUNSは60 | E-01 (MINUTES_BETWEEN_RUNS = 60) | ○ |
| C-02 | cronは`0 * * * *` | E-04 (cron設定) | ○ |
| C-03 | lease_timeoutは30分 | E-01 (lease_timeout: 30.minutes) | ○ |
| C-04 | ExclusiveLeaseGuardをinclude | E-01 (include ExclusiveLeaseGuard) | ○ |
| C-05 | CronjobQueueをinclude | E-01 (include CronjobQueue) | ○ |
| C-06 | data_consistencyはalways | E-01 (data_consistency :always) | ○ |
| C-07 | feature_categoryはcontinuous_integration | E-01 (feature_category :continuous_integration) | ○ |
| C-08 | 3つの子ワーカーを呼び出す | E-01 (delayed_workers配列) | ○ |
| C-09 | 子ワーカーは15分間隔でスケジュール | E-01 (interval計算: 60/(3+1)=15) | ○ |
| C-10 | DropPendingServiceを実行 | E-01 (Ci::StuckBuilds::DropPendingService.new.execute) | ○ |
| C-11 | ペンディングタイムアウトは1日 | E-02 (BUILD_PENDING_OUTDATED_TIMEOUT = 1.day) | ○ |
| C-12 | スタックタイムアウトは1時間 | E-02 (BUILD_PENDING_STUCK_TIMEOUT = 1.hour) | ○ |
| C-13 | バッチサイズは100件 | E-03 (BATCH_SIZE = 100) | ○ |
| C-14 | failure_reasonはstuck_or_timeout_failure | E-02 (failure_reason: :stuck_or_timeout_failure) | ○ |
| C-15 | OptimisticLockingで3回リトライ | E-03 (retry_lock build, 3) | ○ |
| C-16 | エラー時はdoom!で代替処理 | E-03 (build.doom!) | ○ |
| C-17 | ErrorTrackingでエラー報告 | E-03 (Gitlab::ErrorTracking.track_exception) | ○ |
| C-18 | ログにbuild_id等を出力 | E-03 (log_dropping_message) | ○ |
| C-19 | カテゴリはCI/CD | E-05 (バッチ一覧.csv) | ○ |
| C-20 | 監視閾値の具体値 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 監視・アラートの具体的な閾値の根拠がない
  - 候補：運用マニュアル / 監視設定ファイル / SREドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コード解析により大部分の主張が検証済み

## 6) レビュアーチェックリスト（最小）
- [ ] 子ワーカーのスケジュール間隔（15分）が適切か確認
- [ ] ペンディングタイムアウト（1日）とスタックタイムアウト（1時間）の妥当性確認
- [ ] 監視閾値の設定が運用環境と一致しているか確認
