---
generated_at: 2026-01-22 14:45:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：20-Database_CiNamespaceMirrorsConsistencyCheckWorker

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **実行スケジュールの具体的な間隔**：Cronスケジュール設定ファイル未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/database/ci_namespace_mirrors_consistency_check_worker.rb`
- E-02: `app/services/database/consistency_check_service.rb`
- E-03: `app/services/database/consistency_fix_service.rb`
- E-04: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CronjobQueue を include | E-01 L6 | ○ |
| C-02 | sidekiq_options retry: false | E-01 L8 | ○ |
| C-03 | feature_category は :cell | E-01 L9 | ○ |
| C-04 | data_consistency は :sticky | E-01 L10 | ○ |
| C-05 | idempotent ワーカーである | E-01 L11 | ○ |
| C-06 | version 1 | E-01 L13 | ○ |
| C-07 | source_model: Namespace | E-01 L17 | ○ |
| C-08 | target_model: Ci::NamespaceMirror | E-01 L18 | ○ |
| C-09 | source_columns: id, traversal_ids | E-01 L19 | ○ |
| C-10 | target_columns: namespace_id, traversal_ids | E-01 L20 | ○ |
| C-11 | ConsistencyFixService で修復 | E-01 L24-30 | ○ |
| C-12 | sync_event_class: Namespaces::SyncEvent | E-01 L27 | ○ |
| C-13 | メタデータログ出力 | E-01 L33 | ○ |
| C-14 | CURSOR_REDIS_KEY_TTL = 7日 | E-02 L5 | ○ |
| C-15 | EMPTY_RESULT の定義 | E-02 L6 | ○ |
| C-16 | ランダムstart_id生成 | E-02 L91-94 | ○ |
| C-17 | ソースにない場合は destroy! | E-03 L20 | ○ |
| C-18 | SyncEvent.create! で同期イベント作成 | E-03 L40 | ○ |
| C-19 | enqueue_worker 呼び出し | E-03 L23 | ○ |
| C-20 | 具体的な実行間隔 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Cronスケジュール設定ファイルが未確認のため、実行間隔の正確な値を特定できていない
  - 候補：config/initializers/1_settings.rb / sidekiq-cron設定

## 5) リスクフラグ（レビュー観点）
- 0: 整合性チェックロジック - コードで明確に確認可能
- 0: 修復ロジック - 明確に定義
- 1: 実行スケジュールの具体値 - 中リスク（確認推奨）
- 0: データ修復 - 安全な方法で実装（SyncEvent経由）

## 6) レビュアーチェックリスト（最小）
- [ ] 実行スケジュール設定が運用要件と合致しているか確認
- [ ] namespaces と ci_namespace_mirrors の現在のレコード数差分を確認
- [ ] mismatches の監視アラートが設定されているか確認
- [ ] Redis SharedState のカーソルキーが正しく管理されているか確認
- [ ] SyncEvent の処理が正常に動作しているか確認
