---
generated_at: 2026-01-22 14:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：21-Database_CiProjectMirrorsConsistencyCheckWorker

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **実行スケジュールの具体的な時刻**：Cronスケジュール設定ファイルの確認が必要
  2. **処理件数・時間の閾値**：ConsistencyCheckServiceの定数確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/database/ci_project_mirrors_consistency_check_worker.rb`
- E-02: `app/services/database/consistency_check_service.rb`
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ConsistencyCheckServiceを使用してprojectsとci_project_mirrorsを比較 | E-01 L16-21 | ○ |
| C-02 | source_columns: [id, namespace_id] | E-01 L19 | ○ |
| C-03 | target_columns: [project_id, namespace_id] | E-01 L20 | ○ |
| C-04 | 不整合時にConsistencyFixServiceで修復 | E-01 L23-30 | ○ |
| C-05 | Projects::SyncEventを通じて修復 | E-01 L27 | ○ |
| C-06 | feature_category: cell | E-01 L9 | ○ |
| C-07 | data_consistency: sticky | E-01 L10 | ○ |
| C-08 | idempotent! | E-01 L11 | ○ |
| C-09 | retry: false | E-01 L8 | ○ |
| C-10 | CronjobQueue使用 | E-01 L6 | ○ |
| C-11 | 最大25バッチまたは30秒間チェック | E-02 L22-23 (コメント参照) | ○ |
| C-12 | バッチサイズ1000件 | E-02 ConsistencyChecker::BATCH_SIZE参照 | ○ |
| C-13 | カーソルTTL 7日間 | E-02 L5 CURSOR_REDIS_KEY_TTL | ○ |
| C-14 | Redis SharedStateでカーソル管理 | E-02 L86, L98-100 | ○ |
| C-15 | ランダム開始位置の決定 | E-02 L91-94 | ○ |
| C-16 | log_extra_metadata_on_done(:results, results) | E-01 L33 | ○ |
| C-17 | 実行時刻はシステム設定による | **根拠なし** | △ |
| C-18 | バッチ種別はデータ整合性チェック | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 具体的なCronスケジュール設定ファイルが未確認
  - 候補：config/initializers/cronjobs.rb / gitlab.yml / sidekiq-cron設定
- ConsistencyCheckerクラスの詳細実装（BATCH_SIZE定数など）
  - 候補：lib/gitlab/database/consistency_checker.rb

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な処理ロジックはソースコードから明確に確認可能
- 1: 中リスク - 実行スケジュールの詳細は環境依存の可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] ConsistencyCheckServiceの最大バッチ数・時間制限の確認
- [ ] Cronスケジュール設定の確認
- [ ] ConsistencyFixServiceの修復ロジック確認
