---
generated_at: 2026-01-22 14:32:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：22-Database_BatchedBackgroundMigration_SingleDatabaseWorker

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **max_running_migrationsの具体値**：BackgroundWorkSchedulableモジュールの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/database/batched_background_migration/single_database_worker.rb`
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CronjobQueueをinclude | E-01 L9 | ○ |
| C-02 | BackgroundWorkSchedulableをinclude | E-01 L10 | ○ |
| C-03 | Feature Flag execute_batched_migrations_on_schedule | E-01 L14 | ○ |
| C-04 | data_consistency: always | E-01 L19 | ○ |
| C-05 | feature_category: database | E-01 L20 | ○ |
| C-06 | idempotent! | E-01 L21 | ○ |
| C-07 | validate!メソッドでバリデーション | E-01 L25 | ○ |
| C-08 | SharedModel.using_connection使用 | E-01 L27 | ○ |
| C-09 | self.class.enabled?チェック | E-01 L28 | ○ |
| C-10 | BatchedMigration.active_migrations_distinct_on_table | E-01 L30-31 | ○ |
| C-11 | limit: max_running_migrations | E-01 L31 | ○ |
| C-12 | queue_migrations_for_execution呼び出し | E-01 L33 | ○ |
| C-13 | jobs_arguments = [tracking_database, migration.id] | E-01 L40 | ○ |
| C-14 | execution_worker_class.perform_with_capacity | E-01 L42 | ○ |
| C-15 | max_running_migrationsの具体的な値 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- max_running_migrationsの具体的な値とその決定ロジック
  - 候補：BackgroundWorkSchedulableモジュール / 設定ファイル
- execution_worker_classの具体的なクラス名の決定ロジック
  - 候補：サブクラス（CiDatabaseWorker等）での定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コードから明確に読み取れる処理フロー
- 1: 中リスク - 抽象クラスのため、具体的なサブクラス実装の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] BackgroundWorkSchedulableモジュールの実装確認
- [ ] max_running_migrationsの決定ロジック確認
- [ ] execution_worker_classの各サブクラス確認
