---
generated_at: 2026-01-22 14:35:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：23-Database_BackgroundOperation_BaseSchedulerWorker

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **max_running_jobsの具体値**：orchestrator_classの実装確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/database/background_operation/base_scheduler_worker.rb`
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CronjobQueueをinclude | E-01 L7 | ○ |
| C-02 | BackgroundWorkSchedulableをinclude | E-01 L8 | ○ |
| C-03 | Feature Flag schedule_background_operations | E-01 L15 | ○ |
| C-04 | data_consistency: sticky | E-01 L11 | ○ |
| C-05 | feature_category: database | E-01 L12 | ○ |
| C-06 | idempotent! | E-01 L10 | ○ |
| C-07 | validate!メソッドでバリデーション | E-01 L18 | ○ |
| C-08 | SharedModel.using_connection使用 | E-01 L20 | ○ |
| C-09 | self.class.enabled?チェック | E-01 L21 | ○ |
| C-10 | worker_class.schedulable_workers呼び出し | E-01 L31-34 | ○ |
| C-11 | orchestrator_class.max_running_jobs | E-01 L33 | ○ |
| C-12 | jobs_arguments構築 | E-01 L40-42 | ○ |
| C-13 | orchestrator_class.perform_with_capacity | E-01 L44 | ○ |
| C-14 | max_running_jobsの具体的な値 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- max_running_jobsの具体的な値とその決定ロジック
  - 候補：orchestrator_classの各サブクラス実装
- worker_classの具体的な定義
  - 候補：サブクラス（MainSchedulerWorker等）での定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コードから明確に読み取れる処理フロー
- 1: 中リスク - 抽象クラスのため、サブクラス実装の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] orchestrator_classの実装確認
- [ ] max_running_jobsの決定ロジック確認
- [ ] worker_classの各サブクラス確認
