---
generated_at: 2026-01-22 14:42:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：25-LooseForeignKeys_CleanupWorker

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **max_runtimeの具体的な値**：ModificationTrackerクラスの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/loose_foreign_keys/cleanup_worker.rb`
- E-02: `app/services/loose_foreign_keys/process_deleted_records_service.rb`
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CronjobQueueをinclude | E-01 L7 | ○ |
| C-02 | ExclusiveLeaseHelpersをinclude | E-01 L6 | ○ |
| C-03 | retry: false | E-01 L9 | ○ |
| C-04 | feature_category: database | E-01 L10 | ○ |
| C-05 | data_consistency: sticky | E-01 L11 | ○ |
| C-06 | idempotent! | E-01 L12 | ○ |
| C-07 | 分単位でDB選択 | E-01 L43-45 | ○ |
| C-08 | エポックからの分数計算 | E-01 L43 Time.current.to_i / 60 | ○ |
| C-09 | database_base_models_with_gitlab_sharedを使用 | E-01 L44 | ○ |
| C-10 | Turboモード判定 | E-01 L48-52, L54-57 | ○ |
| C-11 | Feature Flag turbo_mode_{connection} | E-01 L56 | ○ |
| C-12 | 排他ロック取得 | E-01 L22 in_lock | ○ |
| C-13 | lock_ttl = max_runtime + 10秒 | E-01 L20 | ○ |
| C-14 | retries: 0 | E-01 L22 | ○ |
| C-15 | ProcessDeletedRecordsService実行 | E-01 L23-28 | ○ |
| C-16 | 統計情報をメタデータに記録 | E-01 L29-32 | ○ |
| C-17 | BATCH_SIZE = 500 | E-02 L5 | ○ |
| C-18 | tracked_tablesをシャッフル | E-02 L84 .shuffle | ○ |
| C-19 | SLIメトリクス記録 | E-02 L48-51, L58-61 | ○ |
| C-20 | max_runtimeの具体的な値 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ModificationTrackerクラスのmax_runtimeの具体的な値
  - 候補：lib/loose_foreign_keys/modification_tracker.rb
- TurboModificationTrackerとの違い
  - 候補：lib/loose_foreign_keys/turbo_modification_tracker.rb

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 処理フローは明確でソースコードから確認可能
- 1: 中リスク - max_runtimeの値によって処理量が変動

## 6) レビュアーチェックリスト（最小）
- [ ] ModificationTrackerのmax_runtime値確認
- [ ] TurboModificationTrackerとの違い確認
- [ ] loose_foreign_keys定義の確認
