---
generated_at: 2026-01-22 14:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：26-LooseForeignKeys_MergeRequestDiffCommitCleanupWorker

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **Cronスケジュールの具体的な設定**：実行時刻の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/loose_foreign_keys/merge_request_diff_commit_cleanup_worker.rb`
- E-02: `app/services/loose_foreign_keys/process_deleted_records_service.rb`
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CronjobQueueをinclude | E-01 L7 | ○ |
| C-02 | ExclusiveLeaseHelpersをinclude | E-01 L6 | ○ |
| C-03 | retry: false | E-01 L9 | ○ |
| C-04 | feature_category: code_review_workflow | E-01 L10 | ○ |
| C-05 | data_consistency: sticky | E-01 L11 | ○ |
| C-06 | idempotent! | E-01 L12 | ○ |
| C-07 | VACUUM実行チェック | E-01 L15, L38-40 | ○ |
| C-08 | PostgresAutovacuumActivity.for_tables使用 | E-01 L39 | ○ |
| C-09 | vacuum_running=trueをログ記録 | E-01 L16 | ○ |
| C-10 | ModificationTracker初期化 | E-01 L20 | ○ |
| C-11 | lock_ttl = max_runtime + 10秒 | E-01 L22 | ○ |
| C-12 | 排他ロック取得 | E-01 L24 in_lock | ○ |
| C-13 | retries: 0 | E-01 L24 | ○ |
| C-14 | ApplicationRecord.connection使用 | E-01 L26 | ○ |
| C-15 | worker_class: self.class | E-01 L29 | ○ |
| C-16 | Cronスケジュールの具体的な設定 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 具体的なCronスケジュール設定
  - 候補：config/initializers/cronjobs.rb / sidekiq-cron設定
- merge_request_diff_commits関連のloose_foreign_keys定義
  - 候補：config/loose_foreign_keys/*.yml

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 処理フローは明確でソースコードから確認可能
- 1: 中リスク - VACUUM競合時の影響評価が必要

## 6) レビュアーチェックリスト（最小）
- [ ] Cronスケジュール設定の確認
- [ ] merge_request_diff_commits関連のloose_foreign_keys定義確認
- [ ] VACUUMスキップ時のログ監視設定確認
