---
generated_at: 2026-01-22 14:48:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：27-LooseForeignKeys_CiPipelinesBuildsCleanupCronWorker

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **CI関連のloose_foreign_keys定義**：対象テーブルの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/loose_foreign_keys/ci_pipelines_builds_cleanup_cron_worker.rb`
- E-02: `app/services/loose_foreign_keys/process_deleted_records_service.rb`
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CronjobQueueをinclude | E-01 L7 | ○ |
| C-02 | ExclusiveLeaseHelpersをinclude | E-01 L6 | ○ |
| C-03 | retry: false | E-01 L9 | ○ |
| C-04 | feature_category: database | E-01 L10 | ○ |
| C-05 | data_consistency: sticky | E-01 L11 | ○ |
| C-06 | idempotent! | E-01 L12 | ○ |
| C-07 | Turboモード判定 | E-01 L36-39 | ○ |
| C-08 | Feature Flag: loose_foreign_keys_turbo_mode_ci | E-01 L37 | ○ |
| C-09 | TurboModificationTracker使用 | E-01 L38 | ○ |
| C-10 | lock_ttl = max_runtime + 10秒 | E-01 L19 | ○ |
| C-11 | 排他ロック取得 | E-01 L21 in_lock | ○ |
| C-12 | retries: 0 | E-01 L21 | ○ |
| C-13 | Ci::ApplicationRecord.connection使用 | E-01 L23 | ○ |
| C-14 | turbo_modeを統計に追加 | E-01 L28 | ○ |
| C-15 | CI関連のloose_foreign_keys定義 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- CI関連テーブルのloose_foreign_keys定義
  - 候補：config/loose_foreign_keys/*.yml
- worker_classによるフィルタリングの対象テーブル
  - 候補：ProcessDeletedRecordsServiceのtracked_tablesロジック

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 処理フローは明確でソースコードから確認可能
- 1: 中リスク - CI関連テーブルの具体的な範囲確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] CI関連のloose_foreign_keys定義確認
- [ ] TurboModificationTrackerの処理速度差確認
- [ ] CI DBの接続設定確認
