---
generated_at: 2026-01-22 14:52:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：28-PersonalAccessTokens_ExpiringWorker

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **Cronスケジュールの具体的な設定**：実行時刻の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/personal_access_tokens/expiring_worker.rb`
- E-02: `app/models/personal_access_token.rb` (NOTIFICATION_INTERVALS)
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CronjobQueueをinclude | E-01 L10 | ○ |
| C-02 | feature_category: system_access | E-01 L12 | ○ |
| C-03 | data_consistency: always | E-01 L8 | ○ |
| C-04 | MAX_TOKENS = 100 | E-01 L14 | ○ |
| C-05 | MAX_RUNTIME = 3分 | E-01 L15 | ○ |
| C-06 | REQUEUE_DELAY = 2分 | E-01 L16 | ○ |
| C-07 | BATCH_SIZE = 100 | E-01 L20 | ○ |
| C-08 | RuntimeLimiter使用 | E-01 L28 | ○ |
| C-09 | notification_intervalsループ | E-01 L29 | ○ |
| C-10 | process_user_tokens呼び出し | E-01 L30 | ○ |
| C-11 | process_project_bot_tokens呼び出し | E-01 L33 | ○ |
| C-12 | 時間超過時に再キュー | E-01 L37 | ○ |
| C-13 | scope_for_notification_interval使用 | E-01 L56 | ○ |
| C-14 | for_user_types(:human) | E-01 L57 | ○ |
| C-15 | NotificationService.access_token_about_to_expire | E-01 L192 | ○ |
| C-16 | {interval}_notification_sent_at更新 | E-01 L85-87 | ○ |
| C-17 | expire_notification_delivered更新（7日時） | E-01 L86 | ○ |
| C-18 | プロジェクトボットトークン処理 | E-01 L102-169 | ○ |
| C-19 | execute_web_hooks呼び出し | E-01 L132 | ○ |
| C-20 | resource_access_token_hooks | E-01 L209, L212 | ○ |
| C-21 | bot_resource_access_token_about_to_expire | E-01 L184-188 | ○ |
| C-22 | log_extra_metadata_on_done統計出力 | E-01 L163-168 | ○ |
| C-23 | log_exception実装 | E-01 L195-202 | ○ |
| C-24 | Cronスケジュールの具体的な設定 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 具体的なCronスケジュール設定
  - 候補：config/initializers/cronjobs.rb / sidekiq-cron設定
- NOTIFICATION_INTERVALSの詳細定義
  - 候補：app/models/personal_access_token.rb で確認済み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 処理フローは詳細にソースコードから確認可能
- 1: 中リスク - メール送信の負荷テストが必要

## 6) レビュアーチェックリスト（最小）
- [ ] Cronスケジュール設定の確認
- [ ] メール送信設定の確認
- [ ] Webhook設定の確認
