---
generated_at: 2026-01-22 14:55:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：29-PersonalAccessTokens_ExpiredNotificationWorker

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **Cronスケジュールの具体的な設定**：実行時刻の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/personal_access_tokens/expired_notification_worker.rb`
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CronjobQueueをinclude | E-01 L9 | ○ |
| C-02 | feature_category: system_access | E-01 L11 | ○ |
| C-03 | data_consistency: always | E-01 L7 | ○ |
| C-04 | MAX_TOKENS = 100 | E-01 L13 | ○ |
| C-05 | NotificationService初期化 | E-01 L16 | ○ |
| C-06 | with_personal_access_tokens_expired_today | E-01 L18 | ○ |
| C-07 | without_impersonation.expired_today_and_not_notified | E-01 L20 | ○ |
| C-08 | limit(MAX_TOKENS).pluck(:name) | E-01 L25 | ○ |
| C-09 | access_token_expired通知送信 | E-01 L28 | ○ |
| C-10 | AppLogger.info出力 | E-01 L30 | ○ |
| C-11 | each_batchでupdate_all | E-01 L32-34 | ○ |
| C-12 | after_expiry_notification_delivered = true | E-01 L33 | ○ |
| C-13 | idempotent: false | E-01 L4 コメント参照 | ○ |
| C-14 | Cronスケジュールの具体的な設定 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 具体的なCronスケジュール設定
  - 候補：config/initializers/cronjobs.rb / sidekiq-cron設定
- find_eachのデフォルトバッチサイズ
  - 候補：ActiveRecordデフォルト（1000）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 処理フローは明確でソースコードから確認可能
- 0: 低リスク - シンプルな通知処理

## 6) レビュアーチェックリスト（最小）
- [ ] Cronスケジュール設定の確認
- [ ] メール送信設定の確認
- [ ] expired_today_and_not_notifiedスコープの確認
