---
generated_at: 2026-01-22 14:10:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：3-Ci_ArchiveTracesCronWorker.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **1週間でデータ損失の可能性**：コメントに基づくが詳細な根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/ci/archive_traces_cron_worker.rb`
- E-02: `app/services/ci/archive_trace_service.rb`
- E-03: `config/initializers/1_settings.rb`
- E-04: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | cronは`17 * * * *` | E-03 (cron設定) | ○ |
| C-02 | EXCLUSIVE_LOCK_KEYは'archive_trace_service:batch_execute:lock' | E-02 (EXCLUSIVE_LOCK_KEY) | ○ |
| C-03 | LOCK_TIMEOUTは56分 | E-02 (LOCK_TIMEOUT = 56.minutes) | ○ |
| C-04 | LOOP_TIMEOUTは55分 | E-02 (LOOP_TIMEOUT = 55.minutes) | ○ |
| C-05 | LOOP_LIMITは2000 | E-02 (LOOP_LIMIT = 2000) | ○ |
| C-06 | BATCH_SIZEは100 | E-02 (BATCH_SIZE = 100) | ○ |
| C-07 | data_consistencyはalways | E-01 (data_consistency :always) | ○ |
| C-08 | feature_categoryはcontinuous_integration | E-01 (feature_category :continuous_integration) | ○ |
| C-09 | deduplicate :until_executed, including_scheduled: true | E-01 (deduplicate設定) | ○ |
| C-10 | with_stale_live_traceスコープを使用 | E-02 (Ci::Build.with_stale_live_trace) | ○ |
| C-11 | archival_attempts_available?をチェック | E-02 (job.trace.archival_attempts_available?) | ○ |
| C-12 | can_attempt_archival_now?をチェック | E-02 (job.trace.can_attempt_archival_now?) | ○ |
| C-13 | archive!でアーカイブ実行 | E-02 (job.trace.archive!) | ○ |
| C-14 | remove_pending_state!を実行 | E-02 (job.remove_pending_state!) | ○ |
| C-15 | archive_trace_hooksインテグレーションを実行 | E-02 (execute_integrations(..., :archive_trace_hooks)) | ○ |
| C-16 | AlreadyArchivedErrorを無視 | E-02 (rescue ::Gitlab::Ci::Trace::AlreadyArchivedError) | ○ |
| C-17 | increment_archival_attempts!でリトライ管理 | E-02 (job.trace.increment_archival_attempts!) | ○ |
| C-18 | attempt_archive_cleanup!でクリーンアップ | E-02 (job.trace.attempt_archive_cleanup!) | ○ |
| C-19 | failed_archive_counterメトリクス | E-02 (job_trace_archive_failed_total) | ○ |
| C-20 | 関連Issue #36791 | E-01 (コメント内URL) | ○ |
| C-21 | 関連Issue #51502 | E-02 (issue_url) | ○ |
| C-22 | 1週間でデータ損失の可能性 | **ドキュメントコメントのみ** | △ |

## 4) 不足情報（Unknown / Missing）
- 1週間でデータ損失が発生する具体的なメカニズムの詳細
  - 候補：GitLabドキュメント / インクリメンタルログのアーキテクチャドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コード解析により大部分の主張が検証済み

## 6) レビュアーチェックリスト（最小）
- [ ] インクリメンタルログの保持期間と削除タイミングを確認
- [ ] アーカイブ失敗時のリトライ回数上限を確認
- [ ] オブジェクトストレージへのアーカイブ先設定を確認
