---
generated_at: 2026-01-22 14:58:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：30-DeployTokens_ExpiringWorker

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **Cronスケジュールの具体的な設定**：実行時刻の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/deploy_tokens/expiring_worker.rb`
- E-02: `app/models/deploy_token.rb` (NOTIFICATION_INTERVALS)
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CronjobQueueをinclude | E-01 L11 | ○ |
| C-02 | feature_category: continuous_delivery | E-01 L13 | ○ |
| C-03 | data_consistency: sticky | E-01 L9 | ○ |
| C-04 | idempotent! | E-01 L7 | ○ |
| C-05 | MAX_RUNTIME = 3分 | E-01 L15 | ○ |
| C-06 | REQUEUE_DELAY = 2分 | E-01 L16 | ○ |
| C-07 | BATCH_SIZE = 100 | E-01 L18 | ○ |
| C-08 | RuntimeLimiter使用 | E-01 L21 | ○ |
| C-09 | notification_intervalsループ | E-01 L23 | ○ |
| C-10 | process_deploy_tokens呼び出し | E-01 L24 | ○ |
| C-11 | 時間超過時に再キュー | E-01 L28 | ○ |
| C-12 | scope_for_notification_interval使用 | E-01 L43 | ○ |
| C-13 | project_token.active | E-01 L44-45 | ○ |
| C-14 | with_project_owners_and_maintainers | E-01 L46 | ○ |
| C-15 | Keyset Pagination使用 | E-01 L47-49 | ○ |
| C-16 | Feature Flag: project_deploy_token_expiring_notifications | E-01 L83 | ○ |
| C-17 | プロジェクト存在確認 | E-01 L81-82 | ○ |
| C-18 | owners_and_maintainers取得 | E-01 L85-86 | ○ |
| C-19 | NotificationService.deploy_token_about_to_expire | E-01 L92-96 | ○ |
| C-20 | ErrorTracking使用 | E-01 L64-70, L101-108 | ○ |
| C-21 | update_notification_timestamps | E-01 L62 | ○ |
| C-22 | Cronスケジュールの具体的な設定 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 具体的なCronスケジュール設定
  - 候補：config/initializers/cronjobs.rb / sidekiq-cron設定
- ordered_for_keyset_paginationの実装詳細
  - 候補：app/models/deploy_token.rb

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 処理フローは詳細にソースコードから確認可能
- 1: 中リスク - Feature Flagの有効化状況確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] Cronスケジュール設定の確認
- [ ] Feature Flag有効化状況の確認
- [ ] メール送信設定の確認
