---
generated_at: 2026-01-22 14:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：31-SshKeys_ExpiredNotificationWorker.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **想定処理件数**：具体的な根拠なし（推定値）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/workers/ssh_keys/expired_notification_worker.rb`
- E-02: `app/services/keys/expiry_notification_service.rb`
- E-03: `config/initializers/1_settings.rb:708-710`
- E-04: `app/workers/ssh_keys/expired_notification_worker.rb:14` (BATCH_SIZE定義)

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | バッチ名がSshKeys::ExpiredNotificationWorkerである | E-01 | ○ |
| C-02 | 期限切れSSHキーの通知を行う | E-01, E-02 | ○ |
| C-03 | cronスケジュールは`0 2,14 * * *` | E-03 | ○ |
| C-04 | BATCH_SIZEは500件 | E-04 | ○ |
| C-05 | Keyset Paginationを使用 | E-01:18-34 | ○ |
| C-06 | Keys::ExpiryNotificationServiceを呼び出す | E-01:40, E-02 | ○ |
| C-07 | feature_categoryはcompliance_management | E-01:11 | ○ |
| C-08 | idempotent!が設定されている | E-01:12 | ○ |
| C-09 | data_consistency :always | E-01:7 | ○ |
| C-10 | CronjobQueueをinclude | E-01:9 | ○ |
| C-11 | メール通知を送信する | E-02:33,38 | ○ |
| C-12 | Todoを作成する | E-02:44-49 | ○ |
| C-13 | expiry_notification_delivered_atを更新 | E-02:41 | ○ |
| C-14 | before_expiry_notification_delivered_atを更新 | E-02:35 | ○ |
| C-15 | ユーザー単位で処理 | E-01:36-42 | ○ |
| C-16 | expired_today_and_not_notifiedスコープを使用 | E-01:32 | ○ |
| C-17 | ユーザーの通知受信可否を確認 | E-02:28-29 | ○ |
| C-18 | 想定処理件数は数百〜数千件/日 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- 想定処理件数の見積もり根拠がソースコード内に存在しない
  - 候補：運用実績データ / 監視メトリクス / 設計ドキュメント

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - バッチ処理の基本設計は十分に根拠がある
- 0: 低リスク - idempotent設定により冪等性が保証されている

## 6) レビュアーチェックリスト（最小）

- [ ] 想定処理件数が実際の運用と乖離していないか確認
- [ ] メール送信の頻度（1日2回）が業務要件と合致しているか確認
