---
generated_at: 2026-01-22 14:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：33-ResourceAccessTokens_InactiveTokensDeletionCronWorker.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **想定処理件数**：具体的な根拠なし（推定値）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/workers/resource_access_tokens/inactive_tokens_deletion_cron_worker.rb`
- E-02: `config/initializers/1_settings.rb:582-584`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | バッチ名がResourceAccessTokens::InactiveTokensDeletionCronWorkerである | E-01 | ○ |
| C-02 | 非アクティブなリソースアクセストークンを削除する | E-01:41 | ○ |
| C-03 | cronスケジュールは`0 0 * * *` | E-02 | ○ |
| C-04 | BATCH_SIZEは1,000件 | E-01:13 | ○ |
| C-05 | MAX_RUNTIMEは3分 | E-01:14 | ○ |
| C-06 | feature_categoryはsystem_access | E-01:11 | ○ |
| C-07 | idempotent!が設定されている | E-01:9 | ○ |
| C-08 | data_consistency :sticky | E-01:10 | ○ |
| C-09 | CronjobQueueをinclude | E-01:6 | ○ |
| C-10 | cursorパラメータで継続処理 | E-01:16 | ○ |
| C-11 | inactive_resource_access_tokens_delete_after_days設定を使用 | E-01:17-18 | ○ |
| C-12 | 設定値がない場合は早期リターン | E-01:19 | ○ |
| C-13 | RuntimeLimiterを使用 | E-01:21 | ○ |
| C-14 | User.project_botをフィルター | E-01:24 | ○ |
| C-15 | PersonalAccessTokenのサブクエリでアクティブ判定 | E-01:28-38 | ○ |
| C-16 | DeleteUserWorkerをbulk_perform_async_with_contextsで実行 | E-01:57 | ○ |
| C-17 | 削除理由は"No active token assigned" | E-01:63 | ○ |
| C-18 | skip_authorization: trueを渡す | E-01:62 | ○ |
| C-19 | 実行時間超過時は2分後に自己スケジュール | E-01:44 | ○ |
| C-20 | 想定処理件数は数百〜数千件/日 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- 想定処理件数の見積もり根拠がソースコード内に存在しない
  - 候補：運用実績データ / 監視メトリクス / 設計ドキュメント

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - バッチ処理の基本設計は十分に根拠がある
- 1: 中リスク - ユーザー削除処理のため、誤削除に注意が必要

## 6) レビュアーチェックリスト（最小）

- [ ] inactive_resource_access_tokens_delete_after_daysの設定値が適切か確認
- [ ] 削除対象の判定ロジック（アクティブトークンなし）が業務要件と合致しているか確認
- [ ] DeleteUserWorkerによる削除が関連データに与える影響を確認
