---
generated_at: 2026-01-22 14:00:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：35-Authn_DataRetention_OauthAccessGrantArchiveWorker.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **想定処理件数**：具体的な根拠なし（推定値）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/workers/authn/data_retention/oauth_access_grant_archive_worker.rb`
- E-02: `config/initializers/1_settings.rb:837-839`
- E-03: `app/models/oauth_access_grant.rb:8` (RETENTION_PERIOD定義)

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | バッチ名がAuthn::DataRetention::OauthAccessGrantArchiveWorkerである | E-01 | ○ |
| C-02 | OAuthアクセス許可のアーカイブ（削除）を行う | E-01:37 | ○ |
| C-03 | cronスケジュールは`15 6 * * *` | E-02 | ○ |
| C-04 | BATCH_SIZEは10,000件 | E-01:19 | ○ |
| C-05 | SUB_BATCH_SIZEは1,000件 | E-01:20 | ○ |
| C-06 | MAX_RUNTIMEは3分 | E-01:16 | ○ |
| C-07 | REQUEUE_DELAYは3分 | E-01:17 | ○ |
| C-08 | ITERATION_DELAYは0.1秒 | E-01:18 | ○ |
| C-09 | feature_categoryはsystem_access | E-01:12 | ○ |
| C-10 | idempotent!が設定されている | E-01:9 | ○ |
| C-11 | data_consistency :sticky | E-01:11 | ○ |
| C-12 | CronjobQueueをinclude | E-01:7 | ○ |
| C-13 | authn_data_retention_cleanup_enabled設定をチェック | E-01:24 | ○ |
| C-14 | archive_revoked_access_grantsフィーチャーフラグをチェック | E-01:25 | ○ |
| C-15 | cursorパラメータで継続処理 | E-01:23, E-01:31 | ○ |
| C-16 | RuntimeLimiterを使用 | E-01:27 | ○ |
| C-17 | revoked_atでフィルター | E-01:34 | ○ |
| C-18 | delete_allで削除 | E-01:37 | ○ |
| C-19 | メタデータにover_time, total_deleted, cutoff_dateを記録 | E-01:51-55 | ○ |
| C-20 | 保持期間は1ヶ月 | E-03 | ○ |
| C-21 | defer_on_database_health_signalでDB負荷時延期 | E-01:14 | ○ |
| C-22 | 想定処理件数は数千〜数万件/日 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- 想定処理件数の見積もり根拠がソースコード内に存在しない
  - 候補：運用実績データ / 監視メトリクス / 設計ドキュメント

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - バッチ処理の基本設計は十分に根拠がある
- 0: 低リスク - delete_allを使用した効率的な削除処理
- 1: 中リスク - revoked_at条件のみで削除するため、正しく失効処理されていることが前提

## 6) レビュアーチェックリスト（最小）

- [ ] 保持期間（1ヶ月）がコンプライアンス要件と合致しているか確認
- [ ] revoked_atがnullのレコードが誤って削除されないことを確認
- [ ] OAuth連携しているサードパーティへの影響がないことを確認
