---
generated_at: 2026-01-22 14:00:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：38-RemoveExpiredMembersWorker.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **想定処理件数**：具体的な根拠なし（推定値）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/workers/remove_expired_members_worker.rb`
- E-02: `config/initializers/1_settings.rb:600-602`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | バッチ名がRemoveExpiredMembersWorkerである | E-01 | ○ |
| C-02 | 期限切れメンバーを削除する | E-01:52 | ○ |
| C-03 | cronスケジュールは`10 0 * * *` | E-02 | ○ |
| C-04 | BATCH_SIZEは1,000件 | E-01:13 | ○ |
| C-05 | BATCH_DELAYは10秒 | E-01:14 | ○ |
| C-06 | feature_categoryはsystem_access | E-01:10 | ○ |
| C-07 | data_consistency :always | E-01:6 | ○ |
| C-08 | CronjobQueueをinclude | E-01:8 | ○ |
| C-09 | worker_resource_boundary :cpu | E-01:11 | ○ |
| C-10 | Keyset Paginationを使用 | E-01:40 | ○ |
| C-11 | expires_at降順、id降順でソート | E-01:39 | ○ |
| C-12 | includes(:user, :source)でEager Load | E-01:38 | ○ |
| C-13 | Members::DestroyServiceで削除 | E-01:52 | ○ |
| C-14 | skip_authorization: trueで呼び出し | E-01:52 | ○ |
| C-15 | skip_subresources: trueで呼び出し | E-01:52 | ○ |
| C-16 | project_bot?の場合はユーザーも削除 | E-01:56-61 | ○ |
| C-17 | Users::DestroyServiceで削除 | E-01:57 | ○ |
| C-18 | 削除理由は"Membership expired" | E-01:60 | ○ |
| C-19 | 次ページがある場合は10秒後に自己スケジュール | E-01:31 | ○ |
| C-20 | メタデータにstatus、updated_rowsを記録 | E-01:24-27 | ○ |
| C-21 | エラー時はログ出力して次のメンバーへ | E-01:66-68 | ○ |
| C-22 | 想定処理件数は数百〜数千件/日 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- 想定処理件数の見積もり根拠がソースコード内に存在しない
  - 候補：運用実績データ / 監視メトリクス / 設計ドキュメント

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - バッチ処理の基本設計は十分に根拠がある
- 1: 中リスク - メンバー削除は権限変更を伴うため、誤削除に注意
- 1: 中リスク - プロジェクトボットユーザーの削除は関連リソースに影響する可能性

## 6) レビュアーチェックリスト（最小）

- [ ] expires_atの設定ポリシーが明確か確認
- [ ] メンバー削除時の通知が適切に行われるか確認
- [ ] プロジェクトボット削除による影響範囲を確認
