---
generated_at: 2026-01-22 14:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：39-RemoveExpiredGroupLinksWorker.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **想定処理件数**：具体的な根拠なし（推定値）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/workers/remove_expired_group_links_worker.rb`
- E-02: `config/initializers/1_settings.rb:603-605`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | バッチ名がRemoveExpiredGroupLinksWorkerである | E-01 | ○ |
| C-02 | 期限切れグループリンクを削除する | E-01:13-19 | ○ |
| C-03 | cronスケジュールは`10 0 * * *` | E-02 | ○ |
| C-04 | feature_categoryはuser_management | E-01:10 | ○ |
| C-05 | data_consistency :always | E-01:6 | ○ |
| C-06 | CronjobQueueをinclude | E-01:8 | ○ |
| C-07 | ProjectGroupLink.expiredを処理 | E-01:13 | ○ |
| C-08 | find_eachでProjectGroupLinkを順次処理 | E-01:13 | ○ |
| C-09 | Projects::GroupLinks::DestroyServiceで削除 | E-01:14 | ○ |
| C-10 | link.projectを第1引数に渡す | E-01:14 | ○ |
| C-11 | GroupGroupLink.expiredを処理 | E-01:17 | ○ |
| C-12 | find_in_batchesでGroupGroupLinkをバッチ取得 | E-01:17 | ○ |
| C-13 | Groups::GroupLinks::DestroyServiceでバッチ削除 | E-01:18 | ○ |
| C-14 | 第1引数にnilを渡す | E-01:18 | ○ |
| C-15 | skip_authorization: trueで呼び出し | E-01:14, 18 | ○ |
| C-16 | idempotent!は設定されていない | E-01（設定なし） | ○ |
| C-17 | CronWorkerContextはdisabled | E-01:8 (コメント) | ○ |
| C-18 | 想定処理件数は数十〜数百件/日 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- 想定処理件数の見積もり根拠がソースコード内に存在しない
  - 候補：運用実績データ / 監視メトリクス / 設計ドキュメント

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - バッチ処理の基本設計は十分に根拠がある
- 1: 中リスク - グループリンク削除は共有アクセス権に影響するため、業務影響を確認

## 6) レビュアーチェックリスト（最小）

- [ ] expires_atの設定ポリシーが明確か確認
- [ ] グループリンク削除時の通知が適切に行われるか確認
- [ ] 共有解除による影響範囲（アクセス権変更）を確認
