---
generated_at: 2026-01-22 14:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：40-RemoveUnacceptedMemberInvitesWorker.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **想定処理件数**：具体的な根拠なし（推定値）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/workers/remove_unaccepted_member_invites_worker.rb`
- E-02: `config/initializers/1_settings.rb:606-608`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | バッチ名がRemoveUnacceptedMemberInvitesWorkerである | E-01 | ○ |
| C-02 | 未承諾のメンバー招待を削除する | E-01:17-34 | ○ |
| C-03 | cronスケジュールは`10 15 * * *` | E-02 | ○ |
| C-04 | EXPIRATION_THRESHOLDは90日 | E-01:14 | ○ |
| C-05 | BATCH_SIZEは10,000件 | E-01:15 | ○ |
| C-06 | feature_categoryはsystem_access | E-01:10 | ○ |
| C-07 | data_consistency :always | E-01:6 | ○ |
| C-08 | CronjobQueueをinclude | E-01:8 | ○ |
| C-09 | urgency :low | E-01:11 | ○ |
| C-10 | idempotent!が設定されている | E-01:12 | ○ |
| C-11 | Member.inviteスコープを使用 | E-01:25 | ○ |
| C-12 | created_before(90日前)でフィルター | E-01:26 | ○ |
| C-13 | user_id IS NULLをチェック | E-01:27 | ○ |
| C-14 | loopで削除が0件になるまで継続 | E-01:21, 33 | ○ |
| C-15 | delete_allで削除 | E-01:30 | ○ |
| C-16 | 内部クエリでIDを取得してWHERE INで削除 | E-01:23-30 | ○ |
| C-17 | user_id NULLチェックの理由（承諾済みでtokenが残るケース） | E-01:18-20 (コメント) | ○ |
| C-18 | 想定処理件数は数百〜数千件/日 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- 想定処理件数の見積もり根拠がソースコード内に存在しない
  - 候補：運用実績データ / 監視メトリクス / 設計ドキュメント

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - バッチ処理の基本設計は十分に根拠がある
- 0: 低リスク - 90日の閾値は十分な猶予期間
- 0: 低リスク - user_id NULLチェックにより誤削除を防止

## 6) レビュアーチェックリスト（最小）

- [ ] 90日の閾値が業務要件と合致しているか確認
- [ ] 招待削除前にリマインダーメールが送信されているか確認
- [ ] 削除された招待の監査ログが必要か確認
