---
generated_at: 2026-01-22 14:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：41-MemberInvitationReminderEmailsWorker

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **想定処理件数**：具体的な数値の根拠なし
  2. **監視アラート閾値**：具体的な閾値設定の根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/member_invitation_reminder_emails_worker.rb`
- E-02: `app/services/members/invitation_reminder_email_service.rb`
- E-03: `config/initializers/1_settings.rb` (cron設定)
- E-04: `app/workers/all_queues.yml`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | バッチは未承諾の招待に対してリマインダーメールを送信する | E-01 (perform メソッド) | ○ |
| C-02 | 日次実行（毎日0時0分 UTC） | E-03 (cron: '0 0 * * *') | ○ |
| C-03 | find_in_batchesで招待を分割処理 | E-01 (find_in_batches) | ○ |
| C-04 | InvitationReminderEmailServiceを実行 | E-01, E-02 | ○ |
| C-05 | REMINDER_RATIOは[2, 5, 10] | E-02 (REMINDER_RATIO = [2, 5, 10].freeze) | ○ |
| C-06 | MAX_INVITATION_LIFESPANは14日 | E-02 (MAX_INVITATION_LIFESPAN = 14.0) | ○ |
| C-07 | feature_categoryはgroups_and_projects | E-01 (feature_category :groups_and_projects) | ○ |
| C-08 | urgencyはlow | E-01, E-04 | ○ |
| C-09 | idempotentではない | E-01 (rubocop:disable Scalability/IdempotentWorker) | ○ |
| C-10 | data_consistencyはalways | E-01 (data_consistency :always) | ○ |
| C-11 | 過去10日間（当日除く）の招待を取得 | E-01 (last_ten_days_excluding_today) | ○ |
| C-12 | 有効期限内の招待のみ対象 | E-01 (not_expired) | ○ |
| C-13 | 未承諾の招待のみ対象 | E-01 (not_accepted_invitations) | ○ |
| C-14 | 招待経過日数に応じてリマインダー判定 | E-02 (days_on_which_to_send_reminders) | ○ |
| C-15 | 招待有効期限が14日未満の場合は比例計算 | E-02 (invitation_lifespan_in_days) | ○ |
| C-16 | send_invitation_reminderでメール送信 | E-02 (invitation.send_invitation_reminder) | ○ |
| C-17 | 想定処理件数は数百〜数千件 | **根拠なし** | △ |
| C-18 | 監視閾値（処理時間3600秒、エラー10件） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 想定処理件数の根拠：実運用データまたはパフォーマンステスト結果が必要
  - 候補：GitLab.com運用データ / 負荷テスト結果 / プロダクトマネージャー確認
- 監視アラート閾値の根拠：運用ポリシーまたはSLA定義が必要
  - 候補：GitLab運用マニュアル / インフラチーム確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 設計書の主要な技術的内容はソースコードから確認可能
- 1: 中リスク - パフォーマンス要件と監視設定は推定値であり、実運用での調整が必要な可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] REMINDER_RATIOとMAX_INVITATION_LIFESPANの計算ロジックが正しく理解されているか確認
- [ ] find_in_batchesのバッチサイズがデフォルト値（1000）で適切か確認
- [ ] メール送信失敗時のリトライ動作が要件を満たしているか確認
