---
generated_at: 2026-01-22 14:05:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：42-Members_ExpiringWorker

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **想定処理件数**：具体的な数値の根拠なし
  2. **監視アラート閾値**：具体的な閾値設定の根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/members/expiring_worker.rb`
- E-02: `app/workers/members/expiring_email_notification_worker.rb`
- E-03: `app/models/concerns/expirable.rb`
- E-04: `config/initializers/1_settings.rb` (cron設定)
- E-05: `app/workers/all_queues.yml`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 7日以内に期限切れになるメンバーに通知メールを送信 | E-01, E-03 (DAYS_TO_EXPIRE = 7) | ○ |
| C-02 | 日次実行（毎日1時0分 UTC） | E-04 (cron: '0 1 * * *') | ○ |
| C-03 | BATCH_LIMITは500件 | E-01 (BATCH_LIMIT = 500) | ○ |
| C-04 | each_batch(of: BATCH_LIMIT)で処理 | E-01 | ○ |
| C-05 | ExpiringEmailNotificationWorker.perform_asyncを呼び出す | E-01 | ○ |
| C-06 | pluck_primary_keyでメンバーIDを取得 | E-01 | ○ |
| C-07 | non_invite.non_request.non_minimal_accessで対象をフィルタ | E-01 | ○ |
| C-08 | expiring_and_not_notifiedで未通知メンバーを取得 | E-01 | ○ |
| C-09 | feature_categoryはsystem_access | E-01, E-05 | ○ |
| C-10 | urgencyはlow | E-01, E-05 | ○ |
| C-11 | idempotentではない | E-01 (rubocop:disable) | ○ |
| C-12 | data_consistencyはsticky | E-01 | ○ |
| C-13 | CronjobQueueを使用 | E-01 (include CronjobQueue) | ○ |
| C-14 | 子ワーカーがexpiry_notified_atを更新 | E-02 (member.update expiry_notified_at) | ○ |
| C-15 | 子ワーカーがAboutToExpireMailerでメール送信 | E-02 | ○ |
| C-16 | 子ワーカーはidempotent | E-02 (idempotent!) | ○ |
| C-17 | 子ワーカーは有効なユーザーのみ通知 | E-02 (valid_for_notification?) | ○ |
| C-18 | DAYS_TO_EXPIREはExpirableモジュールで定義 | E-03 | ○ |
| C-19 | 想定処理件数は数百〜数千件 | **根拠なし** | △ |
| C-20 | 監視閾値（処理時間1800秒、エラー5件） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 想定処理件数の根拠：実運用データまたはパフォーマンステスト結果が必要
  - 候補：GitLab.com運用データ / 負荷テスト結果 / プロダクトマネージャー確認
- 監視アラート閾値の根拠：運用ポリシーまたはSLA定義が必要
  - 候補：GitLab運用マニュアル / インフラチーム確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 設計書の主要な技術的内容はソースコードから確認可能
- 1: 中リスク - パフォーマンス要件と監視設定は推定値であり、実運用での調整が必要な可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] DAYS_TO_EXPIREの7日という設定が要件と合致しているか確認
- [ ] BATCH_LIMITの500件がパフォーマンス要件を満たしているか確認
- [ ] 子ワーカーのvalid_for_notification?の条件が適切か確認
- [ ] expiry_notified_atによる重複送信防止ロジックが正しく機能するか確認
