---
generated_at: 2026-01-22 14:10:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：43-Members_SchedulePruneDeletionsWorker

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **監視アラート閾値**：具体的な閾値設定の根拠なし
  2. **残存スケジュール数の閾値**：具体的な閾値設定の根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/members/schedule_prune_deletions_worker.rb`
- E-02: `app/workers/members/prune_deletions_worker.rb`
- E-03: `config/initializers/1_settings.rb` (cron設定)
- E-04: `app/workers/all_queues.yml`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 5分間隔で実行 | E-03 (cron: '*/5 * * * *') | ○ |
| C-02 | PruneDeletionsWorker.perform_with_capacityを呼び出す | E-01 | ○ |
| C-03 | idempotent!で宣言 | E-01 | ○ |
| C-04 | feature_categoryはseat_cost_management | E-01, E-04 | ○ |
| C-05 | data_consistencyはsticky | E-01 | ○ |
| C-06 | urgencyはlow | E-01, E-04 | ○ |
| C-07 | MAX_RUNNING_JOBS = 1 | E-02 | ○ |
| C-08 | MEMBER_BATCH_SIZE = 100 | E-02 | ○ |
| C-09 | SCHEDULE_BATCH_SIZE = 10 | E-02 | ○ |
| C-10 | LimitedCapacity::Workerを使用 | E-02 (include LimitedCapacity::Worker) | ○ |
| C-11 | ExecutionTrackerで実行時間を制御 | E-02 | ○ |
| C-12 | in_hierarchy(namespace)でメンバーを取得 | E-02 | ○ |
| C-13 | DestroyServiceでメンバーを削除 | E-02 | ○ |
| C-14 | skip_subresources: trueを指定 | E-02 | ○ |
| C-15 | AccessDeniedErrorでスケジュールをクリーンアップ | E-02 | ○ |
| C-16 | cleanup_scheduleでスケジュールを削除 | E-02 | ○ |
| C-17 | 処理ログにuser_id, namespace_id, destroyed_count, destroy_duration_sを出力 | E-02 (log_monitoring_data) | ○ |
| C-18 | remaining_work_countでスケジュール数を取得 | E-02 | ○ |
| C-19 | Benchmarkで処理時間を計測 | E-02 | ○ |
| C-20 | 子ワーカーもidempotent! | E-02 | ○ |
| C-21 | 監視閾値（処理時間300秒、エラー3件） | **根拠なし** | △ |
| C-22 | 残存スケジュール数閾値100件 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 監視アラート閾値の根拠：運用ポリシーまたはSLA定義が必要
  - 候補：GitLab運用マニュアル / インフラチーム確認
- 残存スケジュール数の閾値：運用要件または性能要件の定義が必要
  - 候補：プロダクトマネージャー確認 / パフォーマンステスト結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 設計書の主要な技術的内容はソースコードから確認可能
- 1: 中リスク - ExecutionTracker::MAX_RUNTIMEの60秒が実運用で十分かの確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] MAX_RUNNING_JOBS = 1が要件と合致しているか確認
- [ ] MEMBER_BATCH_SIZE = 100とSCHEDULE_BATCH_SIZE = 10のバランスが適切か確認
- [ ] ExecutionTracker::MAX_RUNTIME（60秒）が実際の処理時間に対して十分か確認
- [ ] AccessDeniedError時のクリーンアップ動作が適切か確認
