---
generated_at: 2026-01-22 14:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：44-Users_DeactivateDormantUsersWorker

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **監視アラート閾値**：具体的な閾値設定の根拠なし
  2. **MINIMUM_DAYS_CREATEDの値**：ソースコードで確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/users/deactivate_dormant_users_worker.rb`
- E-02: `app/services/users/deactivate_service.rb`
- E-03: `app/models/user.rb` (dormantスコープ)
- E-04: `config/initializers/1_settings.rb` (cron設定)
- E-05: `app/workers/all_queues.yml`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GitLab.comでは実行されない | E-01 (return if Gitlab.com?) | ○ |
| C-02 | deactivate_dormant_users設定が有効な場合のみ実行 | E-01 | ○ |
| C-03 | 深夜帯に複数回実行（21,42 0-4） | E-04 (cron: '21,42 0-4 * * *') | ○ |
| C-04 | User.dormantスコープで休眠ユーザーを取得 | E-01, E-03 | ○ |
| C-05 | User.with_no_activityスコープでアクティビティなしユーザーを取得 | E-01, E-03 | ○ |
| C-06 | deactivate_dormant_users_period設定で期間を制御 | E-03 | ○ |
| C-07 | DeactivateServiceを使用 | E-01, E-02 | ○ |
| C-08 | admin_botを使用して処理を実行 | E-01 | ○ |
| C-09 | Gitlab::Auth::CurrentUserMode.bypass_session!を使用 | E-01 | ○ |
| C-10 | organization_idごとにadmin_botをキャッシュ | E-01 (@admin_bots) | ○ |
| C-11 | feature_categoryはseat_cost_management | E-01, E-05 | ○ |
| C-12 | data_consistencyはalways | E-01 | ○ |
| C-13 | idempotentではない | E-01 (rubocop:disable) | ○ |
| C-14 | each_batchでバッチ処理 | E-01 | ○ |
| C-15 | ブロック済みユーザーは非アクティブ化エラー | E-02 | ○ |
| C-16 | 内部ユーザーは非アクティブ化不可 | E-02 | ○ |
| C-17 | 既に非アクティブなユーザーはスキップ | E-02 | ○ |
| C-18 | ログにusername, user_id, email等を出力 | E-02 (log_event) | ○ |
| C-19 | can_be_deactivated?で非アクティブ化可否を判定 | E-02 | ○ |
| C-20 | human_or_service_userのみ対象 | E-03 | ○ |
| C-21 | 監視閾値（処理時間3600秒） | **根拠なし** | △ |
| C-22 | MINIMUM_DAYS_CREATEDは90日 | **要確認** | △ |

## 4) 不足情報（Unknown / Missing）
- 監視アラート閾値の根拠：運用ポリシーまたはSLA定義が必要
  - 候補：GitLab運用マニュアル / インフラチーム確認
- MINIMUM_DAYS_CREATEDの正確な値：User モデルでの定義を確認が必要
  - 候補：app/models/user.rb の定数定義を確認

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 休眠ユーザーの自動非アクティブ化は業務影響が大きいため、設定値の妥当性確認が重要
- 1: 中リスク - admin_botの権限とCurrentUserMode.bypass_session!の使用はセキュリティ観点で注意が必要

## 6) レビュアーチェックリスト（最小）
- [ ] deactivate_dormant_users_periodのデフォルト値と設定範囲が適切か確認
- [ ] MINIMUM_DAYS_CREATEDの値が要件と合致しているか確認
- [ ] admin_botの権限スコープが適切に制限されているか確認
- [ ] 非アクティブ化後のユーザー再アクティブ化プロセスが明確か確認
