---
generated_at: 2026-01-22 14:20:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：45-Users_CreateStatisticsWorker

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **監視アラート閾値**：具体的な閾値設定の根拠なし
  2. **目標処理時間60秒**：具体的な根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/users/create_statistics_worker.rb`
- E-02: `app/models/users_statistics.rb`
- E-03: `config/initializers/1_settings.rb` (cron設定)
- E-04: `app/workers/all_queues.yml`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 日次実行（毎日15時2分 UTC） | E-03 (cron: '2 15 * * *') | ○ |
| C-02 | UsersStatistics.create_current_stats!を呼び出す | E-01 | ○ |
| C-03 | RecordInvalidエラーをトラッキング | E-01 (Gitlab::ErrorTracking.track_exception) | ○ |
| C-04 | feature_categoryはuser_profile | E-01, E-04 | ○ |
| C-05 | data_consistencyはsticky | E-01 | ○ |
| C-06 | idempotentではない | E-01 (rubocop:disable) | ○ |
| C-07 | CronjobQueueを使用 | E-01 | ○ |
| C-08 | アクセスレベル別にユーザー数をカウント | E-02 (highest_role_stats) | ○ |
| C-09 | Guest, Planner, Reporter, Developer, Maintainer, Ownerの各レベルをカウント | E-02 | ○ |
| C-10 | ボットユーザー数をカウント | E-02 (bot_stats) | ○ |
| C-11 | ブロックユーザー数をカウント | E-02 (blocked_stats) | ○ |
| C-12 | Gitlab::Database::BatchCountを使用 | E-02 | ○ |
| C-13 | UserHighestRole.with_highest_access_levelでカウント | E-02 (batch_count_for_access_level) | ○ |
| C-14 | latestで最新統計を取得可能 | E-02 | ○ |
| C-15 | activeメソッドで合計アクティブユーザー数を算出 | E-02 | ○ |
| C-16 | totalメソッドでactive+blockedを算出 | E-02 | ○ |
| C-17 | 監視閾値（処理時間120秒、エラー1件） | **根拠なし** | △ |
| C-18 | 目標処理時間60秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 監視アラート閾値の根拠：運用ポリシーまたはSLA定義が必要
  - 候補：GitLab運用マニュアル / インフラチーム確認
- 目標処理時間の根拠：パフォーマンス要件定義が必要
  - 候補：パフォーマンステスト結果 / SLA定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 設計書の主要な技術的内容はソースコードから確認可能
- 0: 低リスク - 統計データの作成は読み取り専用操作が中心で、システムへの影響が限定的

## 6) レビュアーチェックリスト（最小）
- [ ] Gitlab::Database::BatchCountの使用が大規模インスタンスで適切か確認
- [ ] users_statisticsテーブルのデータ保持期間とクリーンアップポリシーを確認
- [ ] 統計データの精度要件（厳密性 vs 概算許容）を確認
- [ ] Plannerロールが追加されていることを確認（比較的新しいロール）
