---
generated_at: 2026-01-22 14:25:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：46-Users_MigrateRecordsToGhostUserInBatchesWorker

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **監視アラート閾値**：具体的な閾値設定の根拠なし
  2. **移行対象テーブル一覧**：完全なリストの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/users/migrate_records_to_ghost_user_in_batches_worker.rb`
- E-02: `app/services/users/migrate_records_to_ghost_user_in_batches_service.rb`
- E-03: `config/initializers/1_settings.rb` (cron設定)
- E-04: `app/workers/all_queues.yml`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 2分間隔で実行 | E-03 (cron: '*/2 * * * *') | ○ |
| C-02 | MigrateRecordsToGhostUserInBatchesServiceを使用 | E-01, E-02 | ○ |
| C-03 | idempotent!で宣言 | E-01 | ○ |
| C-04 | ExclusiveLeaseHelpersを使用 | E-01 (include Gitlab::ExclusiveLeaseHelpers) | ○ |
| C-05 | in_lockで排他制御 | E-01 | ○ |
| C-06 | sidekiq_options retry: false | E-01 | ○ |
| C-07 | feature_categoryはuser_profile | E-01, E-04 | ○ |
| C-08 | data_consistencyはsticky | E-01 | ○ |
| C-09 | LIMIT_SIZE = 1000 | E-02 | ○ |
| C-10 | ExecutionTrackerで実行時間を監視 | E-02 | ○ |
| C-11 | GhostUserMigration.consume_orderでジョブ取得 | E-02 | ○ |
| C-12 | MigrateRecordsToGhostUserServiceを呼び出す | E-02 | ○ |
| C-13 | hard_deleteフラグで削除モードを制御 | E-02 (job.hard_delete) | ○ |
| C-14 | エラー時30分後に再スケジュール | E-02 (consume_after: 30.minutes.from_now) | ○ |
| C-15 | ExecutionTimeOutErrorをキャッチして継続 | E-02 | ○ |
| C-16 | StandardErrorをトラッキング | E-02 (Gitlab::ErrorTracking.track_exception) | ○ |
| C-17 | TTLはMAX_RUNTIMEを使用 | E-01 (ttl: Gitlab::Utils::ExecutionTracker::MAX_RUNTIME) | ○ |
| C-18 | retries: 0でロック取得失敗時はスキップ | E-01 | ○ |
| C-19 | 監視閾値（未処理ジョブ1000件、エラー率10%） | **根拠なし** | △ |
| C-20 | 移行対象はissues, merge_requests, notes等 | **要確認** | △ |

## 4) 不足情報（Unknown / Missing）
- 監視アラート閾値の根拠：運用ポリシーまたはSLA定義が必要
  - 候補：GitLab運用マニュアル / インフラチーム確認
- 移行対象テーブルの完全なリスト：MigrateRecordsToGhostUserServiceの実装確認が必要
  - 候補：app/services/users/migrate_records_to_ghost_user_service.rb の確認

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - ユーザー削除後のデータ移行は重要な処理であり、移行漏れがないか確認が必要
- 1: 中リスク - ExecutionTimeOutError時の中断と再開ロジックが正しく動作するか確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] LIMIT_SIZE = 1000が実運用の負荷に対して適切か確認
- [ ] 30分の再スケジュール間隔が要件と合致しているか確認
- [ ] hard_deleteフラグの動作仕様を理解しているか確認
- [ ] Ghost Userへの移行対象となるすべてのテーブル/カラムを把握しているか確認
- [ ] 排他ロックのTTLがMAX_RUNTIMEで十分か確認
