---
generated_at: 2026-01-22 14:30:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：47-Users_UnconfirmedSecondaryEmailsDeletionCronWorker

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **監視アラート閾値**：具体的な閾値設定の根拠なし
  2. **USERS_UNCONFIRMED_SECONDARY_EMAILS_DELETE_AFTER_DAYSの具体的な値**：設定値の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/users/unconfirmed_secondary_emails_deletion_cron_worker.rb`
- E-02: `config/initializers/1_settings.rb` (cron設定)
- E-03: `app/workers/all_queues.yml`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 1時間間隔で実行（毎時10分） | E-02 (cron: '10 * * * *') | ○ |
| C-02 | BATCH_SIZE = 1000 | E-01 | ○ |
| C-03 | idempotent!で宣言 | E-01 | ○ |
| C-04 | deduplicate :until_executedを使用 | E-01 | ○ |
| C-05 | feature_categoryはuser_management | E-01, E-03 | ○ |
| C-06 | data_consistencyはalways | E-01 | ○ |
| C-07 | loopで削除処理を繰り返す | E-01 | ○ |
| C-08 | unconfirmed_and_created_beforeスコープを使用 | E-01 | ○ |
| C-09 | delete_allで削除 | E-01 | ○ |
| C-10 | 削除件数が0でループ終了 | E-01 (break if records_deleted == 0) | ○ |
| C-11 | USERS_UNCONFIRMED_SECONDARY_EMAILS_DELETE_AFTER_DAYS.days.agoでカットオフ計算 | E-01 | ○ |
| C-12 | CronjobQueueを使用 | E-01 | ○ |
| C-13 | limitでBATCH_SIZE件ずつ取得 | E-01 | ○ |
| C-14 | created_cut_offメソッドでカットオフ日時を算出 | E-01 | ○ |
| C-15 | 監視閾値（処理時間600秒） | **根拠なし** | △ |
| C-16 | USERS_UNCONFIRMED_SECONDARY_EMAILS_DELETE_AFTER_DAYSの具体的な値 | **要確認** | △ |

## 4) 不足情報（Unknown / Missing）
- 監視アラート閾値の根拠：運用ポリシーまたはSLA定義が必要
  - 候補：GitLab運用マニュアル / インフラチーム確認
- USERS_UNCONFIRMED_SECONDARY_EMAILS_DELETE_AFTER_DAYSの具体的な値：ApplicationSetting定数の確認が必要
  - 候補：app/models/application_setting.rb の確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 設計書の主要な技術的内容はソースコードから確認可能
- 0: 低リスク - 未確認メールの削除は影響範囲が限定的

## 6) レビュアーチェックリスト（最小）
- [ ] USERS_UNCONFIRMED_SECONDARY_EMAILS_DELETE_AFTER_DAYSの値が要件と合致しているか確認
- [ ] BATCH_SIZE = 1000がパフォーマンス要件を満たしているか確認
- [ ] unconfirmed_and_created_beforeスコープの条件が正確か確認
- [ ] プライマリメールが削除対象から確実に除外されているか確認
