---
generated_at: 2026-01-22 14:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：48-UserStatusCleanup_BatchWorker

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **監視アラート閾値**：具体的な閾値設定の根拠なし
  2. **scheduled_for_cleanupスコープの詳細条件**：モデルでの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/user_status_cleanup/batch_worker.rb`
- E-02: `app/services/users/batch_status_cleaner_service.rb`
- E-03: `config/initializers/1_settings.rb` (cron設定)
- E-04: `app/workers/all_queues.yml`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 1分間隔で実行 | E-03 (cron: '* * * * *') | ○ |
| C-02 | MAX_RUNTIME = 30秒 | E-01 (MAX_RUNTIME = 30.seconds) | ○ |
| C-03 | idempotent!で宣言 | E-01 | ○ |
| C-04 | feature_categoryはuser_profile | E-01, E-04 | ○ |
| C-05 | data_consistencyはsticky | E-01 | ○ |
| C-06 | CronjobQueueを使用 | E-01 | ○ |
| C-07 | UserStatus.scheduled_for_cleanup.exists?で存在確認 | E-01 | ○ |
| C-08 | Process.clock_gettime(CLOCK_MONOTONIC)で時間計測 | E-01 | ○ |
| C-09 | BatchStatusCleanerService.executeを呼び出す | E-01, E-02 | ○ |
| C-10 | BATCH_SIZE = 100 | E-02 | ○ |
| C-11 | SELECT FOR UPDATE SKIP LOCKEDを使用 | E-02 | ○ |
| C-12 | delete_allで削除 | E-02 | ○ |
| C-13 | deleted_rowsを返す | E-02 | ○ |
| C-14 | 削除件数がBATCH_SIZE未満でループ終了 | E-01 | ○ |
| C-15 | 経過時間がMAX_RUNTIME超過でループ終了 | E-01 | ○ |
| C-16 | user_idサブクエリで削除対象を特定 | E-02 | ○ |
| C-17 | 監視閾値（処理時間60秒、残存10000件） | **根拠なし** | △ |
| C-18 | scheduled_for_cleanupスコープの詳細条件 | **要確認** | △ |

## 4) 不足情報（Unknown / Missing）
- 監視アラート閾値の根拠：運用ポリシーまたはSLA定義が必要
  - 候補：GitLab運用マニュアル / インフラチーム確認
- scheduled_for_cleanupスコープの詳細条件：UserStatusモデルでの確認が必要
  - 候補：app/models/user_status.rb の確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 設計書の主要な技術的内容はソースコードから確認可能
- 0: 低リスク - ユーザーステータスの削除は影響範囲が限定的

## 6) レビュアーチェックリスト（最小）
- [ ] MAX_RUNTIME = 30秒が1分間隔の実行に対して適切か確認
- [ ] BATCH_SIZE = 100がパフォーマンス要件を満たしているか確認
- [ ] SKIP LOCKEDの動作が期待通りか確認
- [ ] scheduled_for_cleanupスコープの条件（clear_status_at）を確認
