---
generated_at: 2026-01-22 14:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：49-AuthorizedProjectUpdate_PeriodicRecalculateWorker

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **監視アラート閾値**：具体的な閾値設定の根拠なし
  2. **子ワーカーの詳細動作**：UserRefreshOverUserRangeWorkerの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/authorized_project_update/periodic_recalculate_worker.rb`
- E-02: `app/services/authorized_project_update/periodic_recalculate_service.rb`
- E-03: `config/initializers/1_settings.rb` (cron設定)
- E-04: `app/workers/all_queues.yml`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 月2回実行（1日と15日の1時45分） | E-03 (cron: '45 1 1,15 * *') | ○ |
| C-02 | PeriodicRecalculateService.new.executeを呼び出す | E-01, E-02 | ○ |
| C-03 | idempotent!で宣言 | E-01 | ○ |
| C-04 | feature_categoryはpermissions | E-01, E-04 | ○ |
| C-05 | data_consistencyはsticky | E-01 | ○ |
| C-06 | urgencyはlow | E-01, E-04 | ○ |
| C-07 | BATCH_SIZE = 450 | E-02 | ○ |
| C-08 | DELAY_INTERVAL = 50秒 | E-02 (DELAY_INTERVAL = 50.seconds.to_i) | ○ |
| C-09 | User.minimum(:id)とUser.maximum(:id)を取得 | E-02 | ○ |
| C-10 | min_idまたはmax_idがnilの場合は終了 | E-02 | ○ |
| C-11 | each_slice(BATCH_SIZE).with_index(1)で分割 | E-02 | ○ |
| C-12 | UserRefreshOverUserRangeWorker.perform_inで遅延キューイング | E-02 | ○ |
| C-13 | delay = DELAY_INTERVAL * indexで遅延時間を計算 | E-02 | ○ |
| C-14 | batch.minmaxでユーザーID範囲を渡す | E-02 | ○ |
| C-15 | CronjobQueueを使用 | E-01 | ○ |
| C-16 | with_index(1)により初回から遅延あり | E-02 | ○ |
| C-17 | 監視閾値（キューイング所要時間300秒、エラー率5%） | **根拠なし** | △ |
| C-18 | 子ワーカーはdata_consistency: delayed | **要確認** | △ |

## 4) 不足情報（Unknown / Missing）
- 監視アラート閾値の根拠：運用ポリシーまたはSLA定義が必要
  - 候補：GitLab運用マニュアル / インフラチーム確認
- 子ワーカーの詳細動作：UserRefreshOverUserRangeWorkerの実装確認が必要
  - 候補：app/workers/authorized_project_update/user_refresh_over_user_range_worker.rb の確認

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 権限の再計算は重要な処理であり、処理漏れがないか確認が必要
- 1: 中リスク - 大規模インスタンスでのジョブ数とDELAY_INTERVALの妥当性確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] BATCH_SIZE = 450が大規模インスタンスで適切か確認
- [ ] DELAY_INTERVAL = 50秒が子ワーカーの処理時間に対して適切か確認
- [ ] 月2回の実行頻度が要件と合致しているか確認
- [ ] 子ワーカーの重複排除ロジックが正しく機能するか確認
- [ ] 全ユーザーの権限が漏れなく再計算されることを確認
