---
generated_at: 2026-01-22 14:20:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-Ci_StuckBuilds_DropScheduledWorker.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/ci/stuck_builds/drop_scheduled_worker.rb`
- E-02: `app/services/ci/stuck_builds/drop_scheduled_service.rb`
- E-03: `app/services/ci/stuck_builds/drop_helpers.rb`
- E-04: `app/workers/stuck_ci_jobs_worker.rb`
- E-05: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | idempotent!が設定 | E-01 (idempotent!) | ○ |
| C-02 | ExclusiveLeaseGuardをinclude | E-01 (include ExclusiveLeaseGuard) | ○ |
| C-03 | CronjobQueueをinclude | E-01 (include CronjobQueue) | ○ |
| C-04 | data_consistencyはalways | E-01 (data_consistency :always) | ○ |
| C-05 | feature_categoryはcontinuous_integration | E-01 (feature_category :continuous_integration) | ○ |
| C-06 | lease_timeoutは30分 | E-01 (lease_timeout: 30.minutes) | ○ |
| C-07 | DropScheduledServiceを実行 | E-01 (Ci::StuckBuilds::DropScheduledService.new.execute) | ○ |
| C-08 | BUILD_SCHEDULED_OUTDATED_TIMEOUTは1時間 | E-02 (BUILD_SCHEDULED_OUTDATED_TIMEOUT = 1.hour) | ○ |
| C-09 | scheduledスコープを使用 | E-02 (Ci::Build.scheduled) | ○ |
| C-10 | scheduled_at_beforeで1時間前を指定 | E-02 (scheduled_at_before(BUILD_SCHEDULED_OUTDATED_TIMEOUT.ago)) | ○ |
| C-11 | failure_reasonはstale_schedule | E-02 (failure_reason: :stale_schedule) | ○ |
| C-12 | BATCH_SIZEは100件 | E-03 (BATCH_SIZE = 100) | ○ |
| C-13 | OptimisticLockingで3回リトライ | E-03 (retry_lock build, 3) | ○ |
| C-14 | エラー時はdoom!で代替処理 | E-03 (build.doom!) | ○ |
| C-15 | StuckCiJobsWorkerから呼び出し | E-04 (Ci::StuckBuilds::DropScheduledWorker) | ○ |
| C-16 | カテゴリはCI/CD | E-05 (バッチ一覧.csv) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がコードから検証済み

## 6) レビュアーチェックリスト（最小）
- [ ] 1時間の停滞判定閾値が業務要件と一致しているか確認
- [ ] stale_scheduleのfailure_reasonが適切か確認
- [ ] 遅延実行ジョブの正常なライフサイクルを確認
