---
generated_at: 2026-01-22 14:45:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：50-AdjournedProjectsDeletionCronWorker

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **監視アラート閾値**：具体的な閾値設定の根拠なし
  2. **deletion_adjourned_periodのデフォルト値**：設定値の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/adjourned_projects_deletion_cron_worker.rb`
- E-02: `app/workers/adjourned_project_deletion_worker.rb`
- E-03: `config/initializers/1_settings.rb` (cron設定)
- E-04: `app/workers/all_queues.yml`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 日次実行（毎日7時0分 UTC） | E-03 (cron: '0 7 * * *') | ○ |
| C-02 | INTERVAL = 3秒 | E-01 (INTERVAL = 3.seconds.to_i) | ○ |
| C-03 | idempotentではない | E-01 (rubocop:disable Scalability/IdempotentWorker) | ○ |
| C-04 | feature_categoryはcompliance_management | E-01, E-04 | ○ |
| C-05 | data_consistencyはsticky | E-01 | ○ |
| C-06 | CronjobQueueを使用 | E-01 (include CronjobQueue) | ○ |
| C-07 | deletion_adjourned_period.days.ago.to_dateでカットオフ計算 | E-01 | ○ |
| C-08 | with_route.with_deleting_userでプロジェクト取得 | E-01 | ○ |
| C-09 | marked_for_deletion_beforeスコープを使用 | E-01 | ○ |
| C-10 | find_each(batch_size: 100)で処理 | E-01 | ○ |
| C-11 | with_index(0)でインデックス取得 | E-01 | ○ |
| C-12 | delay = index * INTERVALで遅延計算 | E-01 | ○ |
| C-13 | AdjournedProjectDeletionWorker.perform_inでキューイング | E-01 | ○ |
| C-14 | with_context(project:, user:)を設定 | E-01 | ○ |
| C-15 | 子ワーカーはretry: 3 | E-02 (sidekiq_options retry: 3) | ○ |
| C-16 | 子ワーカーはAdjournedDeletionServiceを呼び出す | E-02 | ○ |
| C-17 | 元々EEからCEに移動された | E-01 (コメント) | ○ |
| C-18 | deleting_userをuser引数として渡す | E-02 | ○ |
| C-19 | 監視閾値（キューイング所要時間600秒、エラー率5%） | **根拠なし** | △ |
| C-20 | deletion_adjourned_periodのデフォルト値 | **要確認** | △ |

## 4) 不足情報（Unknown / Missing）
- 監視アラート閾値の根拠：運用ポリシーまたはSLA定義が必要
  - 候補：GitLab運用マニュアル / インフラチーム確認
- deletion_adjourned_periodのデフォルト値：ApplicationSettingでの確認が必要
  - 候補：app/models/application_setting.rb またはドキュメントの確認

## 5) リスクフラグ（レビュー観点）
- 2: 高リスク - プロジェクト削除は不可逆操作であり、誤削除防止のための確認が重要
- 1: 中リスク - 子ワーカーのretry: 3が失敗時に十分かの確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] deletion_adjourned_periodの設定値と猶予期間が要件と合致しているか確認
- [ ] INTERVAL = 3秒がシステム負荷に対して適切か確認
- [ ] batch_size: 100が大量削除時のパフォーマンスに適切か確認
- [ ] deleting_userがnullの場合の動作を確認
- [ ] プロジェクト削除の不可逆性について関係者が認識しているか確認
