---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：51-AdjournedGroupDeletionWorker

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **実行頻度の詳細**：Cron設定ファイルの確認が必要
  2. **監視設定**：具体的な閾値・アラート先はインフラ設定依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/adjourned_group_deletion_worker.rb`
- E-02: `app/services/namespaces/groups/adjourned_deletion_service.rb`
- E-03: `app/workers/all_queues.yml`
- E-04: `app/models/group.rb`（推定：marked_for_deletion_beforeスコープ）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 猶予期間後のグループ削除を実行する | E-01 L17-35 | ○ |
| C-02 | deletion_adjourned_period設定から猶予期間を取得 | E-01 L18 | ○ |
| C-03 | marked_for_deletion_beforeで対象グループを検索 | E-01 L20-21 | ○ |
| C-04 | バッチサイズは100件 | E-01 L23 | ○ |
| C-05 | 20秒間隔でスケジュール | E-01 L13, L27 | ○ |
| C-06 | deletion_scheduleから削除ユーザーを取得 | E-01 L25-28 | ○ |
| C-07 | with_contextでnamespace/userを設定 | E-01 L30 | ○ |
| C-08 | AdjournedDeletionServiceを実行 | E-01 L31-33 | ○ |
| C-09 | 権限確認後に削除または復元を実行 | E-02 L11-17 | ○ |
| C-10 | GroupDestroyWorker.perform_inで削除 | E-02 L28 | ○ |
| C-11 | Groups::RestoreServiceで復元 | E-02 L32-35 | ○ |
| C-12 | data_consistency: :sticky | E-01 L9 | ○ |
| C-13 | feature_category: :groups_and_projects | E-01 L15 | ○ |
| C-14 | CronjobQueueをinclude | E-01 L11 | ○ |
| C-15 | find_eachでメモリ効率的に処理 | E-01 L23 | ○ |
| C-16 | EEからCEに移動されたクラス | E-01 L3-5 rubocop:disable コメント | ○ |
| C-17 | 実行頻度は日次 | **根拠なし** | △ |
| C-18 | 監視閾値・アラート先 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-17：Cron設定ファイル（config/initializers/1_settings.rb または sidekiq-cron設定）の確認が必要
  - 候補：config/initializers/1_settings.rb / config/gitlab.yml / sidekiq-cron設定
- C-18：監視・アラート設定はインフラレベルで定義される可能性
  - 候補：Prometheus設定 / AlertManager設定 / GitLab管理画面

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コード構造の理解
- 1: 中リスク - 実行頻度の確認（運用影響あり）
- 0: 低リスク - 権限チェックロジック（コードで明確）

## 6) レビュアーチェックリスト（最小）
- [ ] Cron実行頻度が運用要件と一致しているか確認
- [ ] deletion_adjourned_period設定値が適切か確認
- [ ] グループ復元時の通知有無を確認（NotificationService連携）
- [ ] 大量グループ削除時のパフォーマンス影響を評価
