---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：52-InactiveProjectsDeletionCronWorker

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **10分間隔の実行頻度**：コメントに記載あるが、Cron設定ファイルの確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/projects/inactive_projects_deletion_cron_worker.rb`
- E-02: `app/workers/all_queues.yml`
- E-03: `app/services/projects/mark_for_deletion_service.rb`（推定）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 非アクティブプロジェクトの自動削除を実行 | E-01 L21-57 | ○ |
| C-02 | 10分間隔でCronジョブとして実行 | E-01 L14コメント | ○ |
| C-03 | 最大実行時間は4分 | E-01 L16 MAX_RUN_TIME = 4.minutes | ○ |
| C-04 | delete_inactive_projects?で有効化確認 | E-01 L22 | ○ |
| C-05 | 前回処理中断位置をRedisで管理 | E-01 L17, L92-107 | ○ |
| C-06 | 100件単位でバッチ取得 | E-01 L30 each_batch(of: 100) | ○ |
| C-07 | dormant.not_aimed_for_deletionでフィルタ | E-01 L31 | ○ |
| C-08 | DormantProjectsDeletionWarningTrackerで警告管理 | E-01 L26, L48 | ○ |
| C-09 | InactiveProjectsDeletionNotificationWorkerで通知 | E-01 L81 | ○ |
| C-10 | MarkForDeletionServiceで削除マーク | E-01 L77 | ○ |
| C-11 | TimeoutErrorで処理中断 | E-01 L19, L36-37 | ○ |
| C-12 | 中断位置を保存して次回継続 | E-01 L35-36, L54-56 | ○ |
| C-13 | 全件処理完了時に中断位置リセット | E-01 L54 | ○ |
| C-14 | idempotent!指定あり | E-01 L9 | ○ |
| C-15 | data_consistency: :always | E-01 L10 | ○ |
| C-16 | urgency: :low | E-01 L12 | ○ |
| C-17 | grace_months_after_deletion_notificationを計算 | E-01 L65-70 | ○ |
| C-18 | 組織ごとにadmin_botを使用 | E-01 L114-117 | ○ |
| C-19 | log_audit_eventはEEで実装 | E-01 L84-86コメント | ○ |
| C-20 | with_contextでproject/user設定 | E-01 L41 | ○ |
| C-21 | LAST_PROCESSED_INACTIVE_PROJECT_REDIS_KEY使用 | E-01 L17 | ○ |
| C-22 | Cron設定ファイルでの間隔指定 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-22：Cron設定の詳細はsidekiq-cron設定またはconfig/gitlab.ymlで確認が必要
  - 候補：config/initializers/1_settings.rb / ee/config/initializers/1_settings.rb

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 処理ロジックの理解（コードで明確）
- 1: 中リスク - 大量プロジェクト環境での4分制限の妥当性
- 0: 低リスク - Redis依存の信頼性（Gitlab標準パターン）

## 6) レビュアーチェックリスト（最小）
- [ ] inactive_projects_delete_after_months設定値が運用要件と一致
- [ ] inactive_projects_send_warning_email_after_months設定値が適切
- [ ] 大量プロジェクト環境で4分制限が十分か確認
- [ ] Redis障害時の挙動を確認（中断位置消失の影響）
