---
generated_at: 2026-01-22 10:40:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：53-ScheduleRefreshBuildArtifactsSizeStatisticsWorker

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **Cron実行頻度の詳細**：設定ファイルの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/projects/schedule_refresh_build_artifacts_size_statistics_worker.rb`
- E-02: `app/workers/projects/refresh_build_artifacts_size_statistics_worker.rb`
- E-03: `app/workers/all_queues.yml`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ビルドアーティファクトサイズ統計の更新をスケジュール | E-01 L14-16 | ○ |
| C-02 | perform_with_capacityを呼び出し | E-01 L15 | ○ |
| C-03 | CronjobQueueをinclude | E-01 L6 | ○ |
| C-04 | idempotent!指定あり | E-01 L12 | ○ |
| C-05 | data_consistency: :always | E-01 L8 | ○ |
| C-06 | feature_category: :job_artifacts | E-01 L10 | ○ |
| C-07 | LimitedCapacity::Workerパターン使用 | E-02 L7 | ○ |
| C-08 | MAX_RUNNING_LOW = 1 | E-02 L15 | ○ |
| C-09 | MAX_RUNNING_MEDIUM = 3 | E-02 L16 | ○ |
| C-10 | MAX_RUNNING_HIGH = 5 | E-02 L17 | ○ |
| C-11 | Feature Flagで並列数制御 | E-02 L41-50 | ○ |
| C-12 | remaining_work_countで残作業確認 | E-02 L30-39 | ○ |
| C-13 | BuildArtifactsSizeRefresh.remaining.any?で存在確認 | E-02 L34 | ○ |
| C-14 | log_extra_metadata_on_doneでメタデータ出力 | E-02 L23-27 | ○ |
| C-15 | RefreshBuildArtifactsSizeStatisticsService実行 | E-02 L20 | ○ |
| C-16 | Cron実行頻度の具体的な間隔 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-16：Cron実行頻度はsidekiq-cron設定ファイルの確認が必要
  - 候補：config/initializers/1_settings.rb / app/workers/all_queues.yml

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 処理ロジック（明確なパターン）
- 1: 中リスク - Feature Flag無効時の挙動確認
- 0: 低リスク - 並列数制御の妥当性

## 6) レビュアーチェックリスト（最小）
- [ ] Feature Flagの有効化状態を確認
- [ ] 並列数設定が環境のリソースに適切か確認
- [ ] BuildArtifactsSizeRefreshテーブルのデータ投入プロセスを確認
