---
generated_at: 2026-01-22 10:45:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：54-TrendingProjectsWorker

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **実行頻度の詳細**：Cron設定ファイルの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/trending_projects_worker.rb`
- E-02: `app/models/trending_project.rb`
- E-03: `app/workers/all_queues.yml`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | トレンドプロジェクト一覧を更新 | E-01 L12-16 | ○ |
| C-02 | TrendingProject.refresh!を実行 | E-01 L15 | ○ |
| C-03 | 'Refreshing trending projects'をログ出力 | E-01 L14 | ○ |
| C-04 | CronjobQueueをinclude | E-01 L8 | ○ |
| C-05 | data_consistency: :always | E-01 L6 | ○ |
| C-06 | feature_category: :source_code_management | E-01 L10 | ○ |
| C-07 | MONTHS_TO_INCLUDE = 1 | E-02 L7 | ○ |
| C-08 | PROJECTS_LIMIT = 100 | E-02 L10 | ○ |
| C-09 | トランザクション内でDELETE + INSERT | E-02 L18-35 | ○ |
| C-10 | パブリックプロジェクトのみ対象 | E-02 L30 visibility_level = PUBLIC | ○ |
| C-11 | システムノートを除外 | E-02 L29 system IS FALSE | ○ |
| C-12 | notesテーブルをproject_idでGROUP BY | E-02 L31 | ○ |
| C-13 | ノート数でORDER BY DESC | E-02 L32 | ○ |
| C-14 | 上位100件をLIMIT | E-02 L33 | ○ |
| C-15 | 日次実行 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-15：Cron実行頻度はsidekiq-cron設定ファイルの確認が必要
  - 候補：config/initializers/1_settings.rb / sidekiq-cron設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 集計ロジック（SQLで明確）
- 1: 中リスク - 大規模notesテーブルでのパフォーマンス
- 0: 低リスク - トランザクション分離

## 6) レビュアーチェックリスト（最小）
- [ ] notesテーブルのサイズと集計パフォーマンスを確認
- [ ] project_idカラムにインデックスがあるか確認
- [ ] 集計対象期間（1ヶ月）が要件と一致するか確認
