---
generated_at: 2026-01-22 10:50:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：55-RepositoryCheck::DispatchWorker

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **Cron実行頻度の詳細**：設定ファイルの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/repository_check/dispatch_worker.rb`
- E-02: `app/workers/repository_check/batch_worker.rb`
- E-03: `app/workers/all_queues.yml`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | リポジトリ整合性チェックをディスパッチ | E-01 L20-27 | ○ |
| C-02 | repository_checks_enabledで有効化確認 | E-01 L21 | ○ |
| C-03 | CronjobQueueをinclude | E-01 L11 | ○ |
| C-04 | EachShardWorkerをinclude | E-01 L13 | ○ |
| C-05 | ExclusiveLeaseGuardをinclude | E-01 L14 | ○ |
| C-06 | LEASE_TIMEOUT = 1時間 | E-01 L18 | ○ |
| C-07 | each_eligible_shardで各シャードを処理 | E-01 L24 | ○ |
| C-08 | BatchWorker.perform_asyncをキュー | E-01 L25 | ○ |
| C-09 | data_consistency: :always | E-01 L7 | ○ |
| C-10 | feature_category: :source_code_management | E-01 L16 | ○ |
| C-11 | BatchWorkerがRUN_TIME = 3600秒 | E-02 L14 | ○ |
| C-12 | BatchWorkerがBATCH_SIZE = 10,000 | E-02 L15 | ○ |
| C-13 | 未チェックプロジェクト: 作成から24時間以上 | E-02 L72-73 | ○ |
| C-14 | 既チェックプロジェクト: 最終チェックから1ヶ月以上 | E-02 L80 | ○ |
| C-15 | SingleRepositoryWorkerで個別チェック | E-02 L54 | ○ |
| C-16 | try_obtain_leaseで排他ロック | E-01 L23 | ○ |
| C-17 | shard_nameでBatchWorkerをパラメータ化 | E-01 L25, E-02 L22 | ○ |
| C-18 | Cron実行頻度の具体的な間隔 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18：Cron実行頻度はsidekiq-cron設定ファイルの確認が必要
  - 候補：config/initializers/1_settings.rb / sidekiq-cron設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 処理ロジック（明確）
- 1: 中リスク - 大量プロジェクト環境でのリソース消費
- 0: 低リスク - 排他制御（ExclusiveLeaseGuard使用）

## 6) レビュアーチェックリスト（最小）
- [ ] repository_checks_enabled設定が有効か確認
- [ ] 各シャードの健全性確認（ShardHealthCache）
- [ ] BatchWorkerの同時実行数制限の妥当性確認
