---
generated_at: 2026-01-22 10:55:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：56-RepositoryArchiveCacheWorker

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **Cron実行頻度の詳細**：設定ファイルの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/repository_archive_cache_worker.rb`
- E-02: `app/services/repository_archive_clean_up_service.rb`
- E-03: `app/workers/all_queues.yml`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | リポジトリアーカイブキャッシュのクリーンアップを実行 | E-01 L15-17 | ○ |
| C-02 | RepositoryArchiveCleanUpServiceを呼び出し | E-01 L16 | ○ |
| C-03 | CronjobQueueをinclude | E-01 L10 | ○ |
| C-04 | data_consistency: :always | E-01 L6 | ○ |
| C-05 | feature_category: :source_code_management | E-01 L13 | ○ |
| C-06 | LAST_MODIFIED_TIME_IN_MINUTES = 120 | E-02 L16 | ○ |
| C-07 | MAX_ARCHIVE_DEPTH = 4 | E-02 L19 | ○ |
| C-08 | 対象ファイル形式: tar, bz2, tar.gz, zip | E-02 L40 | ○ |
| C-09 | findコマンドで古いファイルを削除 | E-02 L40 | ○ |
| C-10 | 空ディレクトリを削除 | E-02 L43-44 | ○ |
| C-11 | Gitlab::Metrics.measureでパフォーマンス計測 | E-02 L29 | ○ |
| C-12 | Gitlab::Popen.popenでコマンド実行 | E-02 L51-53 | ○ |
| C-13 | repository_downloads_pathを使用 | E-02 L25 | ○ |
| C-14 | Cron実行頻度の具体的な間隔 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-14：Cron実行頻度はsidekiq-cron設定ファイルの確認が必要
  - 候補：config/initializers/1_settings.rb / sidekiq-cron設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 処理ロジック（シンプルなfindコマンド）
- 1: 中リスク - 大量キャッシュファイル環境でのパフォーマンス
- 0: 低リスク - ファイルシステム操作の権限

## 6) レビュアーチェックリスト（最小）
- [ ] repository_downloads_pathの設定値を確認
- [ ] キャッシュ保持期間（120分）が要件と一致するか確認
- [ ] findコマンド実行のパーミッションを確認
